/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL definitions.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! `FEEL` definitions.

extern crate chrono;
extern crate chrono_tz;
pub extern crate dmntk_common;
#[macro_use]
extern crate lazy_static;
extern crate regex;
extern crate serde;
#[macro_use]
extern crate serde_derive;

pub use ast::{AstNode, OptAstNode};
pub use names::{Name, OptName, QualifiedName};
pub use scope::Scope;
pub use temporal::date::FeelDate;
pub use temporal::dt_duration::FeelDaysAndTimeDuration;
pub use temporal::ym_duration::FeelYearsAndMonthsDuration;
pub use temporal::{subtract, FeelDateTime, FeelTime};
pub use types::{is_built_in_type_name, FeelType};

mod ast;
pub mod bif;
pub mod context;
pub mod dto;
mod names;
mod scope;
mod temporal;
mod types;
pub mod values;

use std::os::raw::c_double;

// External function for rounding using half even mode.
extern "C" {
  fn roundeven(value: c_double) -> c_double;
}

/// Rounds the nearest half even with specified scale.
pub fn round_half_to_even(number: f64, scale: f64) -> f64 {
  let value = (number * 10_f64.powf(scale + 1.0)).trunc() / 10.0;
  let rounded = unsafe { roundeven(value) };
  rounded / 10_f64.powf(scale)
}

/// Checks if the floating-point value is an integer,
/// that is, has no (or very small) fractional part.
pub fn is_integer(value: f64) -> bool {
  value.fract() < f64::EPSILON
}
