/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::{accept, empty_scope};
use crate::lalr::TokenType::StartTextualExpression;

#[test]
fn test_addition_1() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "1+2",
    r#"
        Add
          Numeric 1.
          Numeric 2.
      "#,
    false,
  );
}

#[test]
fn test_addition_2() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "1 + 2",
    r#"
        Add
          Numeric 1.
          Numeric 2.
      "#,
    false,
  );
}

#[test]
fn test_addition_3() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    " 5 +2 +1",
    r#"
        Add
          Add
            Numeric 5.
            Numeric 2.
          Numeric 1.
      "#,
    false,
  );
}

#[test]
fn test_addition_4() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "2+20+200",
    r#"
        Add
          Add
            Numeric 2.
            Numeric 20.
          Numeric 200.
      "#,
    false,
  );
}

#[test]
fn test_addition_6() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "( 1 + 2 ) + ( 3 + 4 )",
    r#"
        Add
          Add
            Numeric 1.
            Numeric 2.
          Add
            Numeric 3.
            Numeric 4.
      "#,
    false,
  );
}

#[test]
fn test_addition_8() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "( ( ( 1 + 2 ) ) )",
    r#"
        Add
          Numeric 1.
          Numeric 2.
      "#,
    false,
  );
}

#[test]
fn test_addition_9() {
  let scope = &mut empty_scope();
  accept(
    scope,
    StartTextualExpression,
    "(1+2)*(3+4)",
    r#"
        Mul
          Add
            Numeric 1.
            Numeric 2.
          Add
            Numeric 3.
            Numeric 4.
      "#,
    false,
  );
}
