/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parsing tables.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! Parsing tables extracted from files generated by `Bison` for `C` language.
//! This file was generated by dedicated tool, do not modify manually.

use crate::parser::Parser;
use dmntk_common::Result;

/// Types of tokens returned by lexer.
#[derive(Debug, Clone)]
pub enum TokenType {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 256,
  YyUndef = 257,
  StartBoxedExpression = 258,
  StartContext = 259,
  StartTextualExpression = 260,
  StartTextualExpressions = 261,
  StartUnaryTests = 262,
  At = 263,
  Not = 264,
  Colon = 265,
  Comma = 266,
  Every = 267,
  For = 268,
  LeftBrace = 269,
  Null = 270,
  RightArrow = 271,
  Of = 272,
  List = 273,
  Range = 274,
  Context = 275,
  Then = 276,
  Function = 277,
  External = 278,
  If = 279,
  RightBrace = 280,
  RightBracket = 281,
  RightParen = 282,
  Return = 283,
  Ellipsis = 284,
  Some = 285,
  Numeric = 286,
  String = 287,
  Boolean = 288,
  Satisfies = 289,
  Else = 290,
  Or = 291,
  And = 292,
  Eq = 293,
  Nq = 294,
  Lt = 295,
  Le = 296,
  Gt = 297,
  Ge = 298,
  Between = 299,
  BetweenAnd = 300,
  In = 301,
  Minus = 302,
  Plus = 303,
  Mul = 304,
  Div = 305,
  Exp = 307,
  Instance = 308,
  Name = 309,
  NameDateTime = 310,
  LeftParen = 311,
  LeftBracket = 312,
  Dot = 313,
}

/// Kinds of symbols recognized by parser.
#[derive(Debug, Clone)]
pub enum SymbolKind {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 1,
  YyUndef = 2,
  YyAccept = 59,
}

///
pub const YY_PACT_N_INF: i16 = -153;

///
pub const YY_TABLE_N_INF: i16 = -134;

///
pub const YY_FINAL: usize = 45;

///
pub const YY_LAST: i16 = 806;

///
pub const YY_N_TOKENS: usize = 59;

/// `YY_TRANSLATE[TOKEN-NUM]` - symbol number corresponding to TOKEN-NUM as returned by lexer.
pub const YY_TRANSLATE: [i8; 314] = [
  0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 3, 4,
  5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44,
  45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58,
];

/// `YY_PACT[STATE-NUM]` - index in YY_TABLE of the portion describing STATE-NUM.
pub const YY_PACT: [i16; 267] = [
  237, 17, 23, 278, 278, -153, 35, -153, -12, 314, -153, -153, -153, -153, -153, 9, 36, 54, -153, 278, 95, 36, -153, -153, -153, 95, 95, 95, 95, 278, -153, -7,
  350, 386, 661, -153, 68, -153, -153, 95, -153, -153, 146, -153, 170, -153, 106, -153, 95, 14, -153, -153, -153, 15, 47, 63, 54, 60, 79, 517, 61, -7, 91,
  -153, -153, -153, 78, -153, -153, -153, -153, 110, -153, -10, 566, 103, 118, 119, 278, 278, 278, 278, 278, 278, 278, 278, -153, 422, 278, 278, 278, 278, 278,
  136, 206, 278, 100, -153, 16, 278, 102, 278, 493, -153, -153, -153, -153, -153, -153, 21, 149, -18, 278, -153, -153, 129, 278, 278, -153, 278, 278, 278, 122,
  -153, 278, 206, -153, -153, -153, 683, 704, 725, 725, 725, 725, 725, 725, 278, 350, 738, 748, 748, 110, 110, 116, 82, -153, 171, 445, -153, -153, 83, -153,
  542, -153, -153, -153, -153, -153, 278, 278, 51, -153, -153, 278, -153, 178, 242, -153, 14, 36, 661, 661, 591, -153, 661, 615, -153, 661, -153, 638, 469,
  -153, -153, -153, 140, -153, -153, -153, 278, 278, -153, -153, 135, -153, -153, -153, 163, -153, 21, 661, 181, 278, 661, -153, 84, -153, -153, 278, 278, 278,
  278, 153, 155, 143, 158, 661, 445, 171, 83, -153, -153, 82, 661, 150, -153, -153, 661, 661, 738, 182, 82, 82, 198, -153, 3, 123, -153, -153, -153, -153,
  -153, 173, 174, 82, 143, -153, -153, -153, 180, -153, 84, -153, -153, -153, 3, -153, -153, 212, 213, -153, -153, 82, 82, 180, -153, -153,
];

/// `YY_DEF_ACT[STATE-NUM]` - default reduction number in state STATE-NUM.
/// Performed when YY_TABLE does not specify something else to do.
/// Zero means the default is an error.
pub const YY_DEF_ACT: [u8; 267] = [
  0, 0, 0, 0, 0, 6, 0, 75, 0, 0, 2, 12, 10, 11, 3, 0, 0, 0, 68, 0, 0, 0, 69, 70, 71, 0, 0, 0, 0, 0, 41, 42, 0, 0, 0, 8, 9, 40, 56, 0, 39, 67, 9, 5, 0, 1, 0,
  125, 85, 0, 9, 84, 72, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 64, 66, 65, 0, 52, 53, 54, 55, 34, 73, 41, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 57, 0, 0, 0, 46, 50, 7, 48, 77, 83, 82, 76, 0, 0, 0, 0, 87, 86, 0, 0, 0, 120, 0, 0, 0, 0, 59, 0, 0, 43, 58, 60, 19, 20, 21, 22, 23, 24, 25, 26,
  0, 0, 28, 30, 29, 31, 32, 33, 0, 89, 41, 0, 38, 90, 0, 91, 0, 36, 63, 61, 62, 45, 0, 0, 0, 80, 78, 0, 127, 135, 0, 128, 0, 0, 123, 16, 121, 119, 13, 0, 100,
  15, 74, 0, 0, 27, 102, 104, 0, 107, 101, 35, 0, 0, 97, 96, 0, 94, 92, 37, 0, 49, 0, 79, 0, 0, 137, 126, 0, 88, 124, 0, 0, 0, 0, 0, 0, 0, 0, 93, 0, 0, 0, 47,
  81, 0, 136, 0, 130, 129, 122, 14, 18, 0, 0, 0, 0, 106, 0, 0, 98, 95, 134, 131, 51, 0, 0, 0, 0, 112, 110, 114, 117, 108, 0, 103, 105, 111, 0, 116, 115, 0, 0,
  132, 113, 0, 0, 117, 109, 118,
];

/// `YY_P_GOTO[NTERM-NUM]`
pub const YY_P_GOTO: [i16; 59] = [
  -153, -153, -153, -3, 230, 0, -153, 152, -153, -152, -153, -153, -153, -153, -153, -5, -153, -153, -15, -153, 232, -153, -153, 74, 46, -153, -153, -153, 89,
  127, -153, 66, 48, -153, 52, -107, -92, -153, -153, -153, -153, -153, 25, 22, -153, 7, -153, 220, -153, -19, -153, -153, -153, -153, 27, -153, 55, -153,
  -153,
];

/// `YY_DEF_GOTO[NTERM-NUM]`
pub const YY_DEF_GOTO: [i16; 59] = [
  0, 6, 44, 102, 35, 50, 137, 43, 103, 104, 182, 37, 38, 39, 97, 62, 63, 40, 41, 125, 11, 46, 108, 109, 163, 110, 12, 51, 114, 149, 150, 151, 195, 152, 192,
  65, 188, 212, 213, 215, 259, 234, 235, 247, 250, 257, 258, 58, 174, 55, 13, 111, 167, 205, 226, 251, 168, 201, 204,
];

/// `YY_TABLE[YY_PACT[STATE-NUM]]` - what to do in state STATE-NUM.
/// If positive, shift that token.
/// If negative, reduce the rule whose number is the opposite.
/// If `YY_TABLE_N_INF`, syntax error.
pub const YY_TABLE: [i16; 807] = [
  34, 34, 66, 36, 42, 64, 49, 197, 198, 165, 64, 64, 64, 64, 245, 177, 59, 76, 76, -99, 67, 68, 69, 70, 64, 112, 71, 75, 77, 74, 49, 7, 161, 64, 98, 45, 166,
  7, 187, 8, 113, 52, 155, 156, 47, 246, 162, 53, 122, 72, 78, 79, 80, 81, 82, 83, 84, 85, 86, 230, 87, 88, 89, 90, 91, 56, 92, 93, -4, 115, 94, 95, 96, 157,
  9, 129, 130, 131, 132, 133, 134, 135, 136, 106, 139, 140, 141, 142, 143, 144, 54, 148, 153, 116, 193, 224, 34, 117, 71, 42, 183, 184, 185, 15, 186, 107, 119,
  120, 57, 169, 194, 225, 124, 171, 172, 187, 173, 175, 176, 122, 123, 178, 148, 76, 187, 187, 22, 23, 24, 187, 239, 105, 127, 75, 180, 181, 60, 187, 106, 242,
  243, 183, 184, 185, 249, 186, -44, -66, 128, 60, 61, 207, 254, 145, 154, 187, 187, 99, 159, 164, 107, 200, 92, 93, 203, 248, 94, 95, 96, 93, 264, 265, 94,
  95, 96, 170, 60, 60, 15, 100, 214, 189, 16, 17, 7, 18, 216, 217, -133, 218, 220, 222, 8, 231, 19, 232, 20, 233, 236, 223, 21, 22, 23, 24, 166, 227, 228, 229,
  244, 241, 25, 26, 27, 28, 15, 252, 253, 101, 16, 17, 7, 18, 256, 262, 30, 31, 32, 33, 8, 263, 19, 10, 20, 146, 14, 199, 21, 22, 23, 24, 1, 2, 3, 4, 5, 221,
  25, 26, 27, 28, 15, 158, 179, 29, 16, 17, 7, 18, 206, 219, 147, 31, 32, 33, 8, 202, 19, 238, 20, 237, 255, 266, 21, 22, 23, 24, 118, 261, 260, 240, 0, 0, 25,
  26, 27, 28, 15, 0, 0, 29, 16, 17, 7, 18, 0, 0, 30, 31, 32, 33, 8, 0, 19, 0, 20, 0, 0, 0, 21, 22, 23, 24, 0, 0, 0, 0, 0, 0, 25, 26, 27, 28, 15, 0, 0, 29, 16,
  17, 7, 18, 0, 0, 30, 31, 32, 33, 8, 0, 19, 0, 48, 0, 0, 0, 21, 22, 23, 24, 0, 0, 0, 0, 0, 0, 25, 26, 27, 28, 15, 0, 0, 29, 16, 17, 7, 18, 0, 0, 30, 31, 32,
  33, 8, 0, 19, 0, 20, 0, 0, 0, 21, 22, 23, 24, 0, 0, 0, 0, 0, 0, 25, 26, 27, 28, 15, 0, 0, 29, 16, 17, 7, 18, 0, 0, 73, 31, 32, 33, 8, 0, 19, 0, 48, 0, 0, 0,
  21, 22, 23, 24, 0, 0, 0, 0, 0, 0, 25, 26, 27, 28, 15, 0, 0, 29, 16, 17, 7, 18, 0, 0, 73, 31, 32, 33, 8, 0, 19, 0, 20, 0, 0, 0, 21, 22, 23, 24, 190, 0, 0, 0,
  0, 0, 25, 26, 27, 28, 0, 0, 0, 29, 0, 0, 191, 0, 0, 0, 30, 31, 138, 33, 211, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 126, 92, 93, 0, 0,
  94, 95, 96, 160, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 0, 78, 79, 80, 81, 82, 83, 84, 85, 86, 121, 87, 88,
  89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 0, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 196, 92, 93, 0, 0, 94, 95, 96, 0, 0, 78, 79, 80, 81,
  82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 126, 92, 93, 0, 0, 94, 95, 96, 0, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 208, 0,
  94, 95, 96, 0, 0, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 209, 78, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88,
  89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 78, 79, 80, 81, 82, 83, 84, 85, 86, 210, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 78, 79, 80, 81, 82, 83,
  84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 79, 80, 81, 82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 80, 81,
  82, 83, 84, 85, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, -134, -134, -134, -134, -134, -134, 86, 0, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94,
  95, 96, 87, 88, 89, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96, 90, 91, 0, 92, 93, 0, 0, 94, 95, 96,
];

/// ???
pub const YY_CHECK: [i16; 807] = [
  3, 4, 21, 3, 4, 20, 9, 159, 160, 27, 25, 26, 27, 28, 11, 122, 19, 32, 33, 29, 25, 26, 27, 28, 39, 11, 29, 32, 33, 32, 33, 14, 11, 48, 39, 0, 54, 14, 145, 22,
  26, 32, 26, 27, 56, 42, 25, 11, 58, 56, 36, 37, 38, 39, 40, 41, 42, 43, 44, 211, 46, 47, 48, 49, 50, 11, 52, 53, 0, 54, 56, 57, 58, 57, 57, 78, 79, 80, 81,
  82, 83, 84, 85, 32, 87, 88, 89, 90, 91, 92, 54, 94, 95, 46, 11, 11, 99, 34, 101, 99, 18, 19, 20, 8, 22, 54, 46, 28, 54, 112, 27, 27, 34, 116, 117, 222, 119,
  120, 121, 58, 29, 124, 125, 138, 231, 232, 31, 32, 33, 236, 222, 25, 29, 138, 137, 138, 54, 244, 32, 231, 232, 18, 19, 20, 236, 22, 0, 29, 29, 54, 55, 170,
  244, 17, 54, 262, 263, 11, 56, 10, 54, 164, 52, 53, 167, 42, 56, 57, 58, 53, 262, 263, 56, 57, 58, 46, 54, 54, 8, 9, 40, 10, 12, 13, 14, 15, 189, 190, 10,
  54, 27, 10, 22, 40, 24, 40, 26, 54, 40, 202, 30, 31, 32, 33, 54, 208, 209, 210, 10, 27, 40, 41, 42, 43, 8, 42, 42, 47, 12, 13, 14, 15, 42, 11, 54, 55, 56,
  57, 22, 16, 24, 1, 26, 27, 2, 161, 30, 31, 32, 33, 3, 4, 5, 6, 7, 199, 40, 41, 42, 43, 8, 99, 125, 47, 12, 13, 14, 15, 169, 193, 54, 55, 56, 57, 22, 23, 24,
  219, 26, 217, 245, 264, 30, 31, 32, 33, 56, 255, 251, 224, -1, -1, 40, 41, 42, 43, 8, -1, -1, 47, 12, 13, 14, 15, -1, -1, 54, 55, 56, 57, 22, -1, 24, -1, 26,
  -1, -1, -1, 30, 31, 32, 33, -1, -1, -1, -1, -1, -1, 40, 41, 42, 43, 8, -1, -1, 47, 12, 13, 14, 15, -1, -1, 54, 55, 56, 57, 22, -1, 24, -1, 26, -1, -1, -1,
  30, 31, 32, 33, -1, -1, -1, -1, -1, -1, 40, 41, 42, 43, 8, -1, -1, 47, 12, 13, 14, 15, -1, -1, 54, 55, 56, 57, 22, -1, 24, -1, 26, -1, -1, -1, 30, 31, 32,
  33, -1, -1, -1, -1, -1, -1, 40, 41, 42, 43, 8, -1, -1, 47, 12, 13, 14, 15, -1, -1, 54, 55, 56, 57, 22, -1, 24, -1, 26, -1, -1, -1, 30, 31, 32, 33, -1, -1,
  -1, -1, -1, -1, 40, 41, 42, 43, 8, -1, -1, 47, 12, 13, 14, 15, -1, -1, 54, 55, 56, 57, 22, -1, 24, -1, 26, -1, -1, -1, 30, 31, 32, 33, 11, -1, -1, -1, -1,
  -1, 40, 41, 42, 43, -1, -1, -1, 47, -1, -1, 27, -1, -1, -1, 54, 55, 56, 57, 11, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, 27, 52, 53, -1,
  -1, 56, 57, 58, 11, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, -1, 36, 37, 38, 39, 40, 41, 42, 43, 44, 21,
  46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, -1, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, 26, 52, 53, -1, -1, 56, 57, 58, -1, -1,
  36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, 27, 52, 53, -1, -1, 56, 57, 58, -1, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50,
  -1, 52, 53, 29, -1, 56, 57, 58, -1, -1, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 35, 36, 37, 38, 39, 40,
  41, 42, 43, 44, -1, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56,
  57, 58, 36, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 37, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50,
  -1, 52, 53, -1, -1, 56, 57, 58, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 38, 39, 40, 41, 42, 43, 44, -1, 46, 47,
  48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 46, 47, 48, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58, 49, 50, -1, 52, 53, -1, -1, 56, 57, 58,
];

/// `YY_R1[YYN]` - symbol number of symbol that rule YYN derives.
pub const YY_R1: [i8; 138] = [
  0, 59, 60, 60, 60, 60, 61, 60, 62, 62, 63, 63, 63, 64, 64, 64, 64, 65, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64,
  64, 64, 64, 64, 64, 66, 66, 67, 67, 67, 68, 68, 69, 70, 70, 70, 70, 70, 71, 72, 72, 72, 73, 73, 73, 74, 75, 75, 76, 76, 77, 77, 77, 77, 78, 77, 80, 79, 81,
  81, 82, 83, 83, 84, 84, 85, 86, 86, 87, 87, 88, 88, 88, 89, 90, 91, 91, 92, 93, 93, 94, 94, 95, 96, 95, 97, 95, 95, 98, 99, 95, 100, 101, 102, 102, 103, 103,
  104, 105, 104, 106, 106, 107, 107, 108, 108, 110, 109, 111, 112, 111, 113, 114, 113, 116, 115, 115, 117, 117,
];

/// `YY_R2[YYN]` - number of symbols on the right hand side of rule YYN.
pub const YY_R2: [i8; 138] = [
  0, 2, 2, 2, 2, 2, 0, 3, 1, 1, 1, 1, 1, 4, 6, 4, 4, 0, 6, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 2, 4, 3, 4, 3, 1, 1, 1, 1, 3, 1, 3, 1, 4, 1, 3, 1, 4,
  2, 2, 2, 2, 1, 2, 3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 4, 0, 3, 1, 2, 3, 1, 3, 1, 1, 2, 1, 2, 1, 3, 1, 1, 1, 2, 3, 1, 3, 2, 1, 3, 1, 3, 1, 0, 5,
  0, 5, 3, 0, 0, 7, 2, 3, 1, 3, 1, 2, 1, 0, 4, 3, 2, 1, 3, 3, 4, 0, 5, 1, 0, 3, 1, 0, 4, 0, 4, 1, 2, 1,
];

/// Calls requested reduce action.
#[inline(always)]
pub fn reduce(parser: &mut Parser, rule_number: i16) -> Result<()> {
  match rule_number {
    6 => parser.action_unary_tests_begin(),                  // $@1: %empty
    13 => parser.action_for(),                               // textual_expression: FOR iteration_contexts RETURN expression
    14 => parser.action_if(),                                // textual_expression: IF expression THEN expression ELSE expression
    15 => parser.action_some(),                              // textual_expression: SOME quantified_expressions SATISFIES expression
    16 => parser.action_every(),                             // textual_expression: EVERY quantified_expressions SATISFIES expression
    17 => parser.action_between_begin(),                     // $@2: %empty
    18 => parser.action_between(),                           // textual_expression: expression BETWEEN $@2 expression BETWEEN_AND expression
    19 => parser.action_disjunction(),                       // textual_expression: expression OR expression
    20 => parser.action_conjunction(),                       // textual_expression: expression AND expression
    21 => parser.action_comparison_eq(),                     // textual_expression: expression EQ expression
    22 => parser.action_comparison_nq(),                     // textual_expression: expression NQ expression
    23 => parser.action_comparison_lt(),                     // textual_expression: expression LT expression
    24 => parser.action_comparison_le(),                     // textual_expression: expression LE expression
    25 => parser.action_comparison_gt(),                     // textual_expression: expression GT expression
    26 => parser.action_comparison_ge(),                     // textual_expression: expression GE expression
    27 => parser.action_comparison_in(),                     // textual_expression: expression IN LEFT_PAREN comparison_in
    28 => parser.action_comparison_in(),                     // textual_expression: expression IN expression
    29 => parser.action_addition(),                          // textual_expression: expression PLUS expression
    30 => parser.action_subtraction(),                       // textual_expression: expression MINUS expression
    31 => parser.action_multiplication(),                    // textual_expression: expression MUL expression
    32 => parser.action_division(),                          // textual_expression: expression DIV expression
    33 => parser.action_exponentiation(),                    // textual_expression: expression EXP expression
    34 => parser.action_negation(),                          // textual_expression: MINUS expression
    35 => parser.action_instance_of(),                       // textual_expression: expression INSTANCE OF type
    36 => parser.action_path(),                              // textual_expression: expression DOT NAME
    37 => parser.action_filter(),                            // textual_expression: expression LEFT_BRACKET expression RIGHT_BRACKET
    41 => parser.action_name(),                              // textual_expression: NAME
    42 => parser.action_name_date_time(),                    // textual_expression: NAME_DATE_TIME
    46 => parser.action_unary_tests_irrelevant(),            // unary_tests: MINUS
    47 => parser.action_unary_tests_negated(),               // unary_tests: NOT LEFT_PAREN positive_unary_tests RIGHT_PAREN
    49 => parser.action_expression_list_tail(),              // positive_unary_tests: expression COMMA positive_unary_tests
    50 => parser.action_expression_list_tail(),              // positive_unary_tests: expression
    51 => parser.action_expression_list_tail(),              // comparison_in: expression COMMA positive_unary_tests RIGHT_PAREN
    52 => parser.action_comparison_unary_lt(),               // simple_positive_unary_test: LT endpoint
    53 => parser.action_comparison_unary_le(),               // simple_positive_unary_test: LE endpoint
    54 => parser.action_comparison_unary_gt(),               // simple_positive_unary_test: GT endpoint
    55 => parser.action_comparison_unary_ge(),               // simple_positive_unary_test: GE endpoint
    57 => parser.action_interval(),                          // interval: interval_start interval_end
    58 => parser.action_interval_start(),                    // interval_start: LEFT_PAREN endpoint ELLIPSIS
    59 => parser.action_interval_start(),                    // interval_start: RIGHT_BRACKET endpoint ELLIPSIS
    60 => parser.action_interval_start(),                    // interval_start: LEFT_BRACKET endpoint ELLIPSIS
    61 => parser.action_interval_end(),                      // interval_end: endpoint RIGHT_PAREN
    62 => parser.action_interval_end(),                      // interval_end: endpoint LEFT_BRACKET
    63 => parser.action_interval_end(),                      // interval_end: endpoint RIGHT_BRACKET
    68 => parser.action_literal_null(),                      // literal: NULL
    69 => parser.action_literal_numeric(),                   // simple_literal: NUMERIC
    70 => parser.action_literal_string(),                    // simple_literal: STRING
    71 => parser.action_literal_boolean(),                   // simple_literal: BOOLEAN
    72 => parser.action_literal_at(),                        // simple_literal: AT STRING
    73 => parser.action_literal_date_time(),                 // $@3: %empty
    75 => parser.action_context_begin(),                     // $@4: %empty
    76 => parser.action_context_end(),                       // context: LEFT_BRACE $@4 context_entries
    77 => parser.action_empty_context(),                     // context_entries: RIGHT_BRACE
    78 => parser.action_context_entry_tail(),                // context_entries: context_entry context_entry_tail
    79 => parser.action_context_entry(),                     // context_entry: key COLON expression
    81 => parser.action_context_entry_tail(),                // context_entry_tail: COMMA context_entry context_entry_tail
    82 => parser.action_key_name(),                          // key: NAME
    83 => parser.action_key_string(),                        // key: STRING
    84 => parser.action_list(),                              // list: LEFT_BRACKET list_items
    85 => parser.action_list_empty(),                        // list_items: RIGHT_BRACKET
    86 => parser.action_list_tail(),                         // list_items: expression list_tail
    88 => parser.action_list_tail(),                         // list_tail: COMMA expression list_tail
    89 => parser.action_function_invocation_no_parameters(), // parameters: RIGHT_PAREN
    90 => parser.action_function_invocation(),               // parameters: named_parameters
    91 => parser.action_function_invocation(),               // parameters: positional_parameters
    92 => parser.action_named_parameters_tail(),             // named_parameters: named_parameter named_parameters_tail
    93 => parser.action_named_parameter(),                   // named_parameter: NAME COLON expression
    95 => parser.action_named_parameters_tail(),             // named_parameters_tail: COMMA named_parameter named_parameters_tail
    96 => parser.action_positional_parameters_tail(),        // positional_parameters: expression positional_parameters_tail
    98 => parser.action_positional_parameters_tail(),        // positional_parameters_tail: COMMA expression positional_parameters_tail
    99 => parser.action_name(),                              // qualified_name: NAME
    102 => parser.action_type_name(),                        // $@5: %empty
    103 => parser.action_list_type(),                        // type: LIST $@5 LT type GT
    104 => parser.action_type_name(),                        // $@6: %empty
    105 => parser.action_range_type(),                       // type: RANGE $@6 LT type GT
    107 => parser.action_type_name(),                        // $@7: %empty
    108 => parser.action_type_name(),                        // $@8: %empty
    109 => parser.action_function_type(),                    // type: FUNCTION $@7 LT function_type_parameters $@8 RIGHT_ARROW type
    110 => parser.action_context_type_entry_tail(),          // context_type_entries: context_type_entry context_type_entry_tail
    111 => parser.action_context_type_entry(),               // context_type_entry: NAME COLON type
    113 => parser.action_context_type_entry_tail(),          // context_type_entry_tail: COMMA context_type_entry context_type_entry_tail
    114 => parser.action_function_type_parameters_empty(),   // function_type_parameters: GT
    115 => parser.action_function_type_parameters_tail(),    // function_type_parameters: type function_type_parameters_tail
    117 => parser.action_type_name(),                        // $@9: %empty
    118 => parser.action_function_type_parameters_tail(),    // function_type_parameters_tail: $@9 COMMA type function_type_parameters_tail
    125 => parser.action_formal_parameters_begin(),          // $@10: %empty
    126 => parser.action_function_definition(),              // function_definition: FUNCTION LEFT_PAREN $@10 formal_parameters external
    127 => parser.action_formal_parameters_empty(),          // formal_parameters: RIGHT_PAREN
    128 => parser.action_formal_parameters_first(),          // $@11: %empty
    131 => parser.action_formal_parameters_tail(),           // $@12: %empty
    133 => parser.action_type_name(),                        // $@13: %empty
    134 => parser.action_formal_parameter_with_type(),       // formal_parameter: NAME $@13 COLON type
    135 => parser.action_formal_parameter_without_type(),    // formal_parameter: NAME
    136 => parser.action_function_body_external(),           // external: EXTERNAL expression
    137 => parser.action_function_body(),                    // external: expression
    _ => Ok(()),
  }
}
