/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use {super::accept, crate::lalr::TokenType::*, dmntk_feel::Scope};

#[test]
fn test_function_definition_no_parameters() {
  let scope = &Scope::default();
  accept(
    scope,
    StartContext,
    r#"{msg: function () "hello!" }"#,
    r#"
        Context
          ContextEntry
            ContextEntryKey `msg`
            FunctionDefinition
              FormalParameters
                (no parameters)
              FunctionBody (external=false)
                String `hello!`
      "#,
    false,
  );
}

#[test]
fn test_function_definition_one_parameter() {
  let scope = &Scope::default();
  accept(
    scope,
    StartContext,
    r#"{pow: function (x: number) x * x }"#,
    r#"
        Context
          ContextEntry
            ContextEntryKey `pow`
            FunctionDefinition
              FormalParameters
                FormalParameter
                  `x`: number
              FunctionBody (external=false)
                Mul
                  Name
                    `x`
                  Name
                    `x`
      "#,
    false,
  );
}

#[test]
fn test_function_definition_two_parameters() {
  let scope = &Scope::default();
  accept(
    scope,
    StartContext,
    r#"{add: function (x: number, y: number) x + y }"#,
    r#"
        Context
          ContextEntry
            ContextEntryKey `add`
            FunctionDefinition
              FormalParameters
                FormalParameter
                  `x`: number
                FormalParameter
                  `y`: number
              FunctionBody (external=false)
                Add
                  Name
                    `x`
                  Name
                    `y`
      "#,
    false,
  );
}

#[test]
fn test_function_definition_three_parameters() {
  let scope = &Scope::default();
  accept(
    scope,
    StartContext,
    r#"{add3:function(x:number,y:number,z:number)x+y+z}"#,
    r#"
        Context
          ContextEntry
            ContextEntryKey `add3`
            FunctionDefinition
              FormalParameters
                FormalParameter
                  `x`: number
                FormalParameter
                  `y`: number
                FormalParameter
                  `z`: number
              FunctionBody (external=false)
                Add
                  Add
                    Name
                      `x`
                    Name
                      `y`
                  Name
                    `z`
      "#,
    false,
  );
}

#[test]
fn test_function_definition_one_parameter_without_type() {
  let scope = &Scope::default();
  accept(
    scope,
    StartContext,
    r#"{inc: function (state) state + 1 }"#,
    r#"
        Context
          ContextEntry
            ContextEntryKey `inc`
            FunctionDefinition
              FormalParameters
                FormalParameter
                  `state`: Any
              FunctionBody (external=false)
                Add
                  Name
                    `state`
                  Numeric 1.
      "#,
    true,
  );
}
