/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! Parser for `FEEL` language.

extern crate dmntk_common;
extern crate dmntk_feel;

use crate::lalr::TokenType::*;
use crate::parser::Parser;
use dmntk_common::Result;
use dmntk_feel::{AstNode, Scope};

mod lalr;
mod lexer;
mod parser;
#[cfg(test)]
mod tests;

/// Parses textual expression using `grammar rule 2`.
pub fn parse_textual_expression(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartTextualExpression, input, trace).parse()
}

/// Parses textual expressions using `grammar rule 3`.
pub fn parse_textual_expressions(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartTextualExpressions, input, trace).parse()
}

/// Parses the unary tests using `grammar rule 17`.
pub fn parse_unary_tests(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartUnaryTests, input, trace).parse()
}

/// Parses a `FEEL` name using `grammar rule 25`.
pub fn parse_name(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartName, input, trace).parse()
}

/// Parses a boxed expression using `grammar rule 53`.
pub fn parse_boxed_expression(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartBoxedExpression, input, trace).parse()
}

/// Parses a context using `grammar rule 59`.
pub fn parse_context(scope: &Scope, input: &str, trace: bool) -> Result<AstNode> {
  Parser::new(scope, StartContext, input, trace).parse()
}
