/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parsing tables.
 * 
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
//! Parsing tables extracted from files generated by `Bison` for `C` language.
//! This file was generated by dedicated tool, do not modify manually.


use {crate::parser::Parser, dmntk_common::Result};

/// Types of tokens returned by lexer.
#[derive(Debug, Clone)]
pub enum TokenType {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 256,
  YyUndef = 257,
  StartBoxedExpression = 258,
  StartContext = 259,
  StartName = 260,
  StartTextualExpression = 261,
  StartTextualExpressions = 262,
  StartUnaryTests = 263,
  At = 264,
  Not = 265,
  Colon = 266,
  Comma = 267,
  Every = 268,
  For = 269,
  LeftBrace = 270,
  Null = 271,
  RightArrow = 272,
  Of = 273,
  List = 274,
  Range = 275,
  Context = 276,
  Then = 277,
  Function = 278,
  External = 279,
  If = 280,
  RightBrace = 281,
  RightBracket = 282,
  RightParen = 283,
  Return = 284,
  Ellipsis = 285,
  Some = 286,
  Numeric = 287,
  String = 288,
  Boolean = 289,
  Satisfies = 290,
  Else = 291,
  Or = 292,
  And = 293,
  Eq = 294,
  Nq = 295,
  Lt = 296,
  Le = 297,
  Gt = 298,
  Ge = 299,
  Between = 300,
  BetweenAnd = 301,
  In = 302,
  Minus = 303,
  Plus = 304,
  Mul = 305,
  Div = 306,
  Exp = 308,
  Instance = 309,
  Name = 310,
  NameDateTime = 311,
  LeftParen = 312,
  LeftBracket = 313,
  Dot = 314,
}

/// Kinds of symbols recognized by parser.
#[derive(Debug, Clone)]
pub enum SymbolKind {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 1,
  YyUndef = 2,
  YyAccept = 60,
}

///
pub const YY_PACT_N_INF: i16 = -155;

///
pub const YY_TABLE_N_INF: i16 = -135;

///
pub const YY_FINAL: usize = 47;

///
pub const YY_LAST: i16 = 821;

///
pub const YY_N_TOKENS: usize = 60;

/// `YY_TRANSLATE[TOKEN-NUM]` - symbol number corresponding to TOKEN-NUM as returned by lexer.
pub const YY_TRANSLATE: [i8; 315] = [
0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 
];

/// `YY_PACT[STATE-NUM]` - index in YY_TABLE of the portion describing STATE-NUM.
pub const YY_PACT: [i16; 269] = [
238, 0, 19, -45, 278, 278, -155, 14, -155, -24, 314, -155, -155, -155, -155, -155, -155, 21, -7, -3, -155, 278, 13, -7, -155, -155, -155, 13, 13, 13, 13, 278, -155, 6, 350, 386, 685, -155, 57, -155, -155, 13, -155, -155, 53, -155, 170, -155, 18, -155, 13, 445, -155, -155, -155, -43, 20, 31, -3, 54, 69, 541, 45, 6, 77, -155, -155, -155, 74, -155, -155, -155, -155, 86, -155, -19, 590, 90, 91, 104, 278, 278, 278, 278, 278, 278, 278, 278, -155, 422, 278, 278, 278, 278, 278, 87, 206, 278, 58, -155, 75, 278, 55, 278, 517, -155, -155, -155, -155, -155, -155, 82, 126, 1, 278, -155, -155, 100, 278, 278, -155, 278, 278, 278, 94, -155, 278, 206, -155, -155, -155, 707, 728, 749, 749, 749, 749, 749, 749, 278, 350, 762, 110, 110, 86, 86, 70, 51, -155, 139, 469, -155, -155, 63, -155, 566, -155, -155, -155, -155, -155, 278, 278, -5, -155, -155, 278, -155, 141, 242, -155, 445, -7, 685, 685, 615, -155, 685, 639, -155, 685, -155, 662, 493, -155, -155, -155, 112, -155, -155, -155, 278, 278, -155, -155, 103, -155, -155, -155, 127, -155, 82, 685, 148, 278, 685, -155, 83, -155, -155, 278, 278, 278, 278, 125, 129, 116, 133, 685, 469, 139, 63, -155, -155, 51, 685, 120, -155, -155, 685, 685, 762, 149, 51, 51, 165, -155, 12, 41, -155, -155, -155, -155, -155, 135, 138, 51, 116, -155, -155, -155, 146, -155, 83, -155, -155, -155, 12, -155, -155, 178, 174, -155, -155, 51, 51, 146, -155, -155, 
];

/// `YY_DEF_ACT[STATE-NUM]` - default reduction number in state STATE-NUM.
/// Performed when YY_TABLE does not specify something else to do.
/// Zero means the default is an error.
pub const YY_DEF_ACT: [u8; 269] = [
0, 0, 0, 0, 0, 0, 7, 0, 76, 0, 0, 2, 13, 11, 12, 3, 4, 0, 0, 0, 69, 0, 0, 0, 70, 71, 72, 0, 0, 0, 0, 0, 42, 43, 0, 0, 0, 9, 10, 41, 57, 0, 40, 68, 10, 6, 0, 1, 0, 126, 86, 0, 10, 85, 73, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 65, 67, 66, 0, 53, 54, 55, 56, 35, 74, 42, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 47, 51, 8, 49, 78, 84, 83, 77, 0, 0, 0, 0, 88, 87, 0, 0, 0, 121, 0, 0, 0, 0, 60, 0, 0, 44, 59, 61, 20, 21, 22, 23, 24, 25, 26, 27, 0, 0, 29, 31, 30, 32, 33, 34, 0, 90, 42, 0, 39, 91, 0, 92, 0, 37, 64, 62, 63, 46, 0, 0, 0, 81, 79, 0, 128, 136, 0, 129, 0, 0, 124, 17, 122, 120, 14, 0, 101, 16, 75, 0, 0, 28, 103, 105, 0, 108, 102, 36, 0, 0, 98, 97, 0, 95, 93, 38, 0, 50, 0, 80, 0, 0, 138, 127, 0, 89, 125, 0, 0, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 48, 82, 0, 137, 0, 131, 130, 123, 15, 19, 0, 0, 0, 0, 107, 0, 0, 99, 96, 135, 132, 52, 0, 0, 0, 0, 113, 111, 115, 118, 109, 0, 104, 106, 112, 0, 117, 116, 0, 0, 133, 114, 0, 0, 118, 110, 119, 
];

/// `YY_P_GOTO[NTERM-NUM]`
pub const YY_P_GOTO: [i16; 59] = [
-155, -155, -155, -4, 181, -1, -155, 93, -155, -154, -155, -155, -155, -155, -155, 8, -155, -155, -9, -155, 190, -155, -155, 33, -2, -155, -155, -155, 27, 78, -155, 15, -12, -155, 4, -108, -92, -155, -155, -155, -155, -155, -31, -40, -155, -42, -155, 172, -155, -21, -155, -155, -155, -155, -18, -155, 10, -155, -155, 
];

/// `YY_DEF_GOTO[NTERM-NUM]`
pub const YY_DEF_GOTO: [i16; 59] = [
0, 7, 46, 104, 37, 52, 139, 45, 105, 106, 184, 39, 40, 41, 99, 64, 65, 42, 43, 127, 12, 48, 110, 111, 165, 112, 13, 53, 116, 151, 152, 153, 197, 154, 194, 67, 190, 214, 215, 217, 261, 236, 237, 249, 252, 259, 260, 60, 176, 57, 14, 113, 169, 207, 228, 253, 170, 203, 206, 
];

/// `YY_TABLE[YY_PACT[STATE-NUM]]` - what to do in state STATE-NUM.
/// If positive, shift that token.
/// If negative, reduce the rule whose number is the opposite.
/// If `YY_TABLE_N_INF`, syntax error.
pub const YY_TABLE: [i16; 822] = [
36, 36, 68, 38, 44, 55, 51, 199, 200, 58, 16, -100, 117, 66, 47, 8, 179, 61, 66, 66, 66, 66, 17, 9, 247, 78, 78, 73, 108, 167, 76, 51, 66, 49, 8, 69, 70, 71, 72, 189, 124, 66, 77, 79, 107, 24, 25, 26, 56, 100, 109, 108, 59, -45, 54, 248, 168, -5, 10, 232, 185, 186, 187, 74, 188, 101, 119, 118, 62, 63, 185, 186, 187, 109, 188, 195, 131, 132, 133, 134, 135, 136, 137, 138, 250, 141, 142, 143, 144, 145, 146, 196, 150, 155, 163, 226, 62, 36, 122, 73, 44, 121, 157, 158, 124, 147, 62, 125, 164, 126, 171, 227, 161, 156, 173, 174, 189, 175, 177, 178, 129, -67, 180, 150, 95, 189, 189, 96, 97, 98, 189, 78, 241, 159, 130, 182, 183, 166, 189, 94, 95, 244, 245, 96, 97, 98, 251, 172, 77, 62, 191, 209, -134, 216, 256, 222, 189, 189, 220, 224, 92, 93, 202, 94, 95, 205, 233, 96, 97, 98, 234, 235, 266, 267, 238, 168, 246, 243, 254, 17, 102, 255, 11, 18, 19, 8, 20, 218, 219, 258, 264, 265, 15, 9, 160, 21, 201, 22, 208, 223, 225, 23, 24, 25, 26, 181, 229, 230, 231, 240, 221, 27, 28, 29, 30, 17, 257, 263, 103, 18, 19, 8, 20, 239, 268, 32, 33, 34, 35, 9, 120, 21, 0, 22, 148, 262, 242, 23, 24, 25, 26, 1, 2, 3, 4, 5, 6, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 149, 33, 34, 35, 9, 204, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 50, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 75, 33, 34, 35, 9, 0, 21, 0, 50, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 75, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 114, 0, 0, 0, 0, 0, 27, 28, 29, 30, 0, 0, 0, 31, 0, 115, 0, 0, 0, 0, 32, 33, 140, 35, 192, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 193, 94, 95, 0, 0, 96, 97, 98, 213, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 128, 94, 95, 0, 0, 96, 97, 98, 162, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 123, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 198, 94, 95, 0, 0, 96, 97, 98, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 128, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 210, 0, 96, 97, 98, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 211, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 80, 81, 82, 83, 84, 85, 86, 87, 88, 212, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, -135, -135, -135, -135, -135, -135, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 
];

/// ???
pub const YY_CHECK: [i16; 822] = [
4, 5, 23, 4, 5, 12, 10, 161, 162, 12, 55, 30, 55, 22, 0, 15, 124, 21, 27, 28, 29, 30, 9, 23, 12, 34, 35, 31, 33, 28, 34, 35, 41, 57, 15, 27, 28, 29, 30, 147, 59, 50, 34, 35, 26, 32, 33, 34, 55, 41, 55, 33, 55, 0, 33, 43, 55, 0, 58, 213, 19, 20, 21, 57, 23, 12, 35, 47, 55, 56, 19, 20, 21, 55, 23, 12, 80, 81, 82, 83, 84, 85, 86, 87, 43, 89, 90, 91, 92, 93, 94, 28, 96, 97, 12, 12, 55, 101, 29, 103, 101, 47, 27, 28, 59, 18, 55, 30, 26, 35, 114, 28, 57, 55, 118, 119, 224, 121, 122, 123, 30, 30, 126, 127, 54, 233, 234, 57, 58, 59, 238, 140, 224, 58, 30, 139, 140, 11, 246, 53, 54, 233, 234, 57, 58, 59, 238, 47, 140, 55, 11, 172, 11, 41, 246, 28, 264, 265, 55, 11, 50, 51, 166, 53, 54, 169, 41, 57, 58, 59, 41, 55, 264, 265, 41, 55, 11, 28, 43, 9, 10, 43, 1, 13, 14, 15, 16, 191, 192, 43, 12, 17, 2, 23, 101, 25, 163, 27, 171, 201, 204, 31, 32, 33, 34, 127, 210, 211, 212, 221, 195, 41, 42, 43, 44, 9, 247, 257, 48, 13, 14, 15, 16, 219, 266, 55, 56, 57, 58, 23, 58, 25, -1, 27, 28, 253, 226, 31, 32, 33, 34, 3, 4, 5, 6, 7, 8, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, 24, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, 12, -1, -1, -1, -1, -1, 41, 42, 43, 44, -1, -1, -1, 48, -1, 27, -1, -1, -1, -1, 55, 56, 57, 58, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 22, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 27, 53, 54, -1, -1, 57, 58, 59, -1, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, 30, -1, 57, 58, 59, -1, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 
];

/// `YY_R1[YYN]` - symbol number of symbol that rule YYN derives.
pub const YY_R1: [i8; 139] = [
0, 60, 61, 61, 61, 61, 61, 62, 61, 63, 63, 64, 64, 64, 65, 65, 65, 65, 66, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 65, 67, 67, 68, 68, 68, 69, 69, 70, 71, 71, 71, 71, 71, 72, 73, 73, 73, 74, 74, 74, 75, 76, 76, 77, 77, 78, 78, 78, 78, 79, 78, 81, 80, 82, 82, 83, 84, 84, 85, 85, 86, 87, 87, 88, 88, 89, 89, 89, 90, 91, 92, 92, 93, 94, 94, 95, 95, 96, 97, 96, 98, 96, 96, 99, 100, 96, 101, 102, 103, 103, 104, 104, 105, 106, 105, 107, 107, 108, 108, 109, 109, 111, 110, 112, 113, 112, 114, 115, 114, 117, 116, 116, 118, 118, 
];

/// `YY_R2[YYN]` - number of symbols on the right hand side of rule YYN.
pub const YY_R2: [i8; 139] = [
0, 2, 2, 2, 2, 2, 2, 0, 3, 1, 1, 1, 1, 1, 4, 6, 4, 4, 0, 6, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 2, 4, 3, 4, 3, 1, 1, 1, 1, 3, 1, 3, 1, 4, 1, 3, 1, 4, 2, 2, 2, 2, 1, 2, 3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 4, 0, 3, 1, 2, 3, 1, 3, 1, 1, 2, 1, 2, 1, 3, 1, 1, 1, 2, 3, 1, 3, 2, 1, 3, 1, 3, 1, 0, 5, 0, 5, 3, 0, 0, 7, 2, 3, 1, 3, 1, 2, 1, 0, 4, 3, 2, 1, 3, 3, 4, 0, 5, 1, 0, 3, 1, 0, 4, 0, 4, 1, 2, 1, 
];

/// Calls requested reduce action.
#[inline(always)]
pub fn reduce(parser: &mut Parser, rule_number: i16) -> Result<()> {
  match rule_number {
    4 => parser.action_name(), // feel: START_NAME NAME
    7 => parser.action_unary_tests_begin(), // $@1: %empty
    14 => parser.action_for(), // textual_expression: FOR iteration_contexts RETURN expression
    15 => parser.action_if(), // textual_expression: IF expression THEN expression ELSE expression
    16 => parser.action_some(), // textual_expression: SOME quantified_expressions SATISFIES expression
    17 => parser.action_every(), // textual_expression: EVERY quantified_expressions SATISFIES expression
    18 => parser.action_between_begin(), // $@2: %empty
    19 => parser.action_between(), // textual_expression: expression BETWEEN $@2 expression BETWEEN_AND expression
    20 => parser.action_disjunction(), // textual_expression: expression OR expression
    21 => parser.action_conjunction(), // textual_expression: expression AND expression
    22 => parser.action_comparison_eq(), // textual_expression: expression EQ expression
    23 => parser.action_comparison_nq(), // textual_expression: expression NQ expression
    24 => parser.action_comparison_lt(), // textual_expression: expression LT expression
    25 => parser.action_comparison_le(), // textual_expression: expression LE expression
    26 => parser.action_comparison_gt(), // textual_expression: expression GT expression
    27 => parser.action_comparison_ge(), // textual_expression: expression GE expression
    28 => parser.action_comparison_in(), // textual_expression: expression IN LEFT_PAREN comparison_in
    29 => parser.action_comparison_in(), // textual_expression: expression IN expression
    30 => parser.action_addition(), // textual_expression: expression PLUS expression
    31 => parser.action_subtraction(), // textual_expression: expression MINUS expression
    32 => parser.action_multiplication(), // textual_expression: expression MUL expression
    33 => parser.action_division(), // textual_expression: expression DIV expression
    34 => parser.action_exponentiation(), // textual_expression: expression EXP expression
    35 => parser.action_negation(), // textual_expression: MINUS expression
    36 => parser.action_instance_of(), // textual_expression: expression INSTANCE OF type
    37 => parser.action_path(), // textual_expression: expression DOT NAME
    38 => parser.action_filter(), // textual_expression: expression LEFT_BRACKET expression RIGHT_BRACKET
    42 => parser.action_name(), // textual_expression: NAME
    43 => parser.action_name_date_time(), // textual_expression: NAME_DATE_TIME
    47 => parser.action_unary_tests_irrelevant(), // unary_tests: MINUS
    48 => parser.action_unary_tests_negated(), // unary_tests: NOT LEFT_PAREN positive_unary_tests RIGHT_PAREN
    50 => parser.action_expression_list_tail(), // positive_unary_tests: expression COMMA positive_unary_tests
    51 => parser.action_expression_list_tail(), // positive_unary_tests: expression
    52 => parser.action_expression_list_tail(), // comparison_in: expression COMMA positive_unary_tests RIGHT_PAREN
    53 => parser.action_comparison_unary_lt(), // simple_positive_unary_test: LT endpoint
    54 => parser.action_comparison_unary_le(), // simple_positive_unary_test: LE endpoint
    55 => parser.action_comparison_unary_gt(), // simple_positive_unary_test: GT endpoint
    56 => parser.action_comparison_unary_ge(), // simple_positive_unary_test: GE endpoint
    58 => parser.action_interval(), // interval: interval_start interval_end
    59 => parser.action_interval_start(), // interval_start: LEFT_PAREN endpoint ELLIPSIS
    60 => parser.action_interval_start(), // interval_start: RIGHT_BRACKET endpoint ELLIPSIS
    61 => parser.action_interval_start(), // interval_start: LEFT_BRACKET endpoint ELLIPSIS
    62 => parser.action_interval_end(), // interval_end: endpoint RIGHT_PAREN
    63 => parser.action_interval_end(), // interval_end: endpoint LEFT_BRACKET
    64 => parser.action_interval_end(), // interval_end: endpoint RIGHT_BRACKET
    69 => parser.action_literal_null(), // literal: NULL
    70 => parser.action_literal_numeric(), // simple_literal: NUMERIC
    71 => parser.action_literal_string(), // simple_literal: STRING
    72 => parser.action_literal_boolean(), // simple_literal: BOOLEAN
    73 => parser.action_literal_at(), // simple_literal: AT STRING
    74 => parser.action_literal_date_time(), // $@3: %empty
    76 => parser.action_context_begin(), // $@4: %empty
    77 => parser.action_context_end(), // context: LEFT_BRACE $@4 context_entries
    78 => parser.action_empty_context(), // context_entries: RIGHT_BRACE
    79 => parser.action_context_entry_tail(), // context_entries: context_entry context_entry_tail
    80 => parser.action_context_entry(), // context_entry: key COLON expression
    82 => parser.action_context_entry_tail(), // context_entry_tail: COMMA context_entry context_entry_tail
    83 => parser.action_key_name(), // key: NAME
    84 => parser.action_key_string(), // key: STRING
    85 => parser.action_list(), // list: LEFT_BRACKET list_items
    86 => parser.action_list_empty(), // list_items: RIGHT_BRACKET
    87 => parser.action_list_tail(), // list_items: expression list_tail
    89 => parser.action_list_tail(), // list_tail: COMMA expression list_tail
    90 => parser.action_function_invocation_no_parameters(), // parameters: RIGHT_PAREN
    91 => parser.action_function_invocation(), // parameters: named_parameters
    92 => parser.action_function_invocation(), // parameters: positional_parameters
    93 => parser.action_named_parameters_tail(), // named_parameters: named_parameter named_parameters_tail
    94 => parser.action_named_parameter(), // named_parameter: NAME COLON expression
    96 => parser.action_named_parameters_tail(), // named_parameters_tail: COMMA named_parameter named_parameters_tail
    97 => parser.action_positional_parameters_tail(), // positional_parameters: expression positional_parameters_tail
    99 => parser.action_positional_parameters_tail(), // positional_parameters_tail: COMMA expression positional_parameters_tail
    100 => parser.action_name(), // qualified_name: NAME
    103 => parser.action_type_name(), // $@5: %empty
    104 => parser.action_list_type(), // type: LIST $@5 LT type GT
    105 => parser.action_type_name(), // $@6: %empty
    106 => parser.action_range_type(), // type: RANGE $@6 LT type GT
    108 => parser.action_type_name(), // $@7: %empty
    109 => parser.action_type_name(), // $@8: %empty
    110 => parser.action_function_type(), // type: FUNCTION $@7 LT function_type_parameters $@8 RIGHT_ARROW type
    111 => parser.action_context_type_entry_tail(), // context_type_entries: context_type_entry context_type_entry_tail
    112 => parser.action_context_type_entry(), // context_type_entry: NAME COLON type
    114 => parser.action_context_type_entry_tail(), // context_type_entry_tail: COMMA context_type_entry context_type_entry_tail
    115 => parser.action_function_type_parameters_empty(), // function_type_parameters: GT
    116 => parser.action_function_type_parameters_tail(), // function_type_parameters: type function_type_parameters_tail
    118 => parser.action_type_name(), // $@9: %empty
    119 => parser.action_function_type_parameters_tail(), // function_type_parameters_tail: $@9 COMMA type function_type_parameters_tail
    126 => parser.action_formal_parameters_begin(), // $@10: %empty
    127 => parser.action_function_definition(), // function_definition: FUNCTION LEFT_PAREN $@10 formal_parameters external
    128 => parser.action_formal_parameters_empty(), // formal_parameters: RIGHT_PAREN
    129 => parser.action_formal_parameters_first(), // $@11: %empty
    132 => parser.action_formal_parameters_tail(), // $@12: %empty
    134 => parser.action_type_name(), // $@13: %empty
    135 => parser.action_formal_parameter_with_type(), // formal_parameter: NAME $@13 COLON type
    136 => parser.action_formal_parameter_without_type(), // formal_parameter: NAME
    137 => parser.action_function_body_external(), // external: EXTERNAL expression
    138 => parser.action_function_body(), // external: expression
    _ => Ok(())
  }
}
