/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::{lalr::TokenType, parser::Parser, scope::ParsingScope};

mod addition;
mod instance_of;
mod name;
mod parser;

/// Creates new, empty scope.
fn empty_scope() -> ParsingScope {
  ParsingScope::default()
}

/// Parses the input text and compared the result with expected value.
fn accept(parsing_scope: &ParsingScope, start_token_type: TokenType, input: &str, expected: &str, trace: bool) {
  let node = Parser::new(parsing_scope.clone(), start_token_type, input, trace).parse().unwrap();
  let actual = node.to_string();
  if actual != expected {
    println!("EXPECTED:\n------------------------------------------------------------{}\n", expected);
    println!("ACTUAL:\n------------------------------------------------------------{}\n", actual);
  }
  assert_eq!(expected, actual);
}

#[test]
fn test_dev() {
  let scope = &mut empty_scope();
  scope.add_name("Person");
  // place a test while developing below
}
