/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! The parsing scope.

///
#[derive(Debug, Clone)]
pub struct ParsingScope {
  context: Vec<Vec<String>>,
}

impl Default for ParsingScope {
  fn default() -> Self {
    Self { context: vec![vec![]] }
  }
}

impl ParsingScope {
  ///
  pub fn new(names: Vec<String>) -> Self {
    Self { context: vec![names] }
  }
  ///
  pub fn contains(&self, name: &str) -> bool {
    for context in self.context.iter().rev() {
      for existing_name in context {
        if name == existing_name {
          return true;
        }
      }
    }
    false
  }
  ///
  pub fn add_name(&mut self, name: &str) {
    if let Some(context) = self.context.iter_mut().last() {
      let value = name.to_string();
      if !context.contains(&value) {
        context.push(value);
      }
    }
  }
  ///
  pub fn add_names(&mut self, names: &[&str]) {
    for &name in names {
      self.add_name(name);
    }
  }
  ///
  pub fn push(&mut self) {
    self.context.push(vec![]);
  }
  ///
  pub fn pop(&mut self) {
    self.context.pop();
  }
}

#[cfg(test)]
mod tests {
  use super::ParsingScope;

  #[test]
  fn test_add_name() {
    let mut ps = ParsingScope::default();
    ps.add_name("card");
    assert_eq!(true, ps.contains("card"));
    assert_eq!(false, ps.contains("dice"));
  }
}
