/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parsing tables.
 * 
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
 
//! Parsing tables extracted from files generated by `Bison` for `C` language.
//! This file was generated by dedicated tool, do not modify manually.


use {crate::parser::Parser, dmntk_common::errors::Result};

/// Types of tokens returned by lexer.
#[derive(Debug, Clone)]
pub enum TokenType {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 256,
  YyUndef = 257,
  StartBoxedExpression = 258,
  StartContext = 259,
  StartName = 260,
  StartTextualExpression = 261,
  StartTextualExpressions = 262,
  StartUnaryTests = 263,
  At = 264,
  Not = 265,
  Colon = 266,
  Comma = 267,
  Every = 268,
  For = 269,
  LeftBrace = 270,
  Null = 271,
  RightArrow = 272,
  Of = 273,
  List = 274,
  Range = 275,
  Context = 276,
  Then = 277,
  Function = 278,
  External = 279,
  If = 280,
  RightBrace = 281,
  RightBracket = 282,
  RightParen = 283,
  Return = 284,
  Ellipsis = 285,
  Some = 286,
  Numeric = 287,
  String = 288,
  Boolean = 289,
  Satisfies = 290,
  Else = 291,
  Or = 292,
  And = 293,
  Eq = 294,
  Nq = 295,
  Lt = 296,
  Le = 297,
  Gt = 298,
  Ge = 299,
  Between = 300,
  BetweenAnd = 301,
  In = 302,
  Minus = 303,
  Plus = 304,
  Mul = 305,
  Div = 306,
  Exp = 308,
  Instance = 309,
  Name = 310,
  NameDateTime = 311,
  LeftParen = 312,
  LeftBracket = 313,
  Dot = 314,
}

/// Kinds of symbols recognized by parser.
#[derive(Debug, Clone)]
pub enum SymbolKind {
  YyEmpty = -2,
  YyEof = 0,
  YyError = 1,
  YyUndef = 2,
  YyAccept = 61,
}

///
pub const YY_PACT_N_INF: i16 = -158;

///
pub const YY_TABLE_N_INF: i16 = -132;

///
pub const YY_FINAL: usize = 47;

///
pub const YY_LAST: i16 = 840;

///
pub const YY_N_TOKENS: usize = 61;

/// `YY_TRANSLATE[TOKEN-NUM]` - symbol number corresponding to TOKEN-NUM as returned by lexer.
pub const YY_TRANSLATE: [i8; 316] = [
0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
];

/// `YY_PACT[STATE-NUM]` - index in YY_TABLE of the portion describing STATE-NUM.
pub const YY_PACT: [i16; 266] = [
179, 0, 31, -26, 287, 287, -158, 53, -158, 2, 323, -158, -158, -158, -158, -158, -158, 24, -7, -3, -158, 287, 11, -7, -158, -158, -158, 11, 11, 11, 11, 287, -158, 4, 359, 395, 694, -158, 63, -158, -158, 11, -158, -158, 84, -158, 165, -158, 36, -6, 11, 454, -158, -158, -158, 9, 27, 59, -3, 57, 79, 550, 50, 4, 80, -158, -158, -158, 77, -158, -158, -158, -158, 87, -158, -9, 599, 85, 86, 89, 287, 287, 287, 287, 287, 287, 287, 287, -158, 431, 287, 287, 287, 287, 287, 96, 215, 287, 74, -158, 10, 287, 73, 287, 526, -158, -158, -158, -158, -158, -158, 39, 122, -158, 124, 251, 14, 287, -158, -158, 100, 287, 287, -158, 287, 287, 287, 88, -158, 287, 215, -158, -158, -158, 716, 737, 758, 758, 758, 758, 758, 758, 287, 359, 771, 781, 781, 87, 87, 112, 82, -158, 137, 478, -158, -158, 42, -158, 575, -158, -158, -158, -158, -158, 287, 287, -23, -158, -158, 287, 141, 287, -158, -158, 98, -158, -158, 454, -7, 694, 694, 624, -158, 694, 648, -158, 694, -158, 671, 502, -158, -158, -158, 113, -158, -158, -158, 287, 287, -158, -158, 101, -158, -158, -158, 127, -158, 39, 694, 82, 694, 14, -158, -158, 287, 287, 287, 287, 119, 120, 107, 123, 694, 478, 137, 42, -158, -158, -158, -158, 694, 694, 771, 135, 82, 82, 157, -158, 12, 52, -158, -158, -158, 129, 130, 82, 107, -158, -158, -158, 133, -158, -158, -158, -158, 12, -158, -158, 177, 160, -158, 82, 82, 133, -158, -158, 
];

/// `YY_DEF_ACT[STATE-NUM]` - default reduction number in state STATE-NUM.
/// Performed when YY_TABLE does not specify something else to do.
/// Zero means the default is an error.
pub const YY_DEF_ACT: [u8; 266] = [
0, 0, 0, 0, 0, 0, 7, 0, 76, 0, 0, 2, 13, 11, 12, 3, 4, 0, 0, 0, 69, 0, 0, 0, 70, 71, 72, 0, 0, 0, 0, 0, 42, 43, 0, 0, 0, 9, 10, 41, 57, 0, 40, 68, 10, 6, 0, 1, 0, 0, 86, 0, 10, 85, 73, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 65, 67, 66, 0, 53, 54, 55, 56, 35, 74, 42, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 47, 51, 8, 49, 78, 84, 83, 77, 0, 0, 127, 133, 0, 0, 0, 88, 87, 0, 0, 0, 121, 0, 0, 0, 0, 60, 0, 0, 44, 59, 61, 20, 21, 22, 23, 24, 25, 26, 27, 0, 0, 29, 31, 30, 32, 33, 34, 0, 90, 42, 0, 39, 91, 0, 92, 0, 37, 64, 62, 63, 46, 0, 0, 0, 81, 79, 0, 0, 0, 134, 126, 0, 129, 128, 0, 0, 124, 17, 122, 120, 14, 0, 101, 16, 75, 0, 0, 28, 103, 105, 0, 108, 102, 36, 0, 0, 98, 97, 0, 95, 93, 38, 0, 50, 0, 80, 0, 135, 0, 89, 125, 0, 0, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 48, 82, 132, 130, 123, 15, 19, 0, 0, 0, 0, 107, 0, 0, 99, 96, 52, 0, 0, 0, 0, 113, 111, 115, 118, 109, 104, 106, 112, 0, 117, 116, 0, 0, 114, 0, 0, 118, 110, 119, 
];

/// `YY_P_GOTO[NTERM-NUM]`
pub const YY_P_GOTO: [i16; 56] = [
-158, -158, -158, -4, 190, -1, -158, 94, -158, -157, -158, -158, -158, -158, -158, -16, -158, -158, 6, -158, 198, -158, -158, 35, -5, -158, -158, -158, 26, 75, -158, 3, -11, -158, -8, -111, -103, -158, -158, -158, -158, -158, -30, -38, -158, -45, -158, 161, -158, -21, -158, -158, 15, 51, -158, -158, 
];

/// `YY_DEF_GOTO[NTERM-NUM]`
pub const YY_DEF_GOTO: [i16; 56] = [
0, 7, 46, 104, 37, 52, 142, 45, 105, 106, 190, 39, 40, 41, 99, 64, 65, 42, 43, 130, 12, 48, 110, 111, 168, 112, 13, 53, 119, 154, 155, 156, 203, 157, 200, 67, 196, 218, 219, 221, 259, 237, 238, 248, 251, 257, 258, 60, 182, 57, 14, 115, 176, 116, 170, 173, 
];

/// `YY_TABLE[YY_PACT[STATE-NUM]]` - what to do in state STATE-NUM.
/// If positive, shift that token.
/// If negative, reduce the rule whose number is the opposite.
/// If `YY_TABLE_N_INF`, syntax error.
pub const YY_TABLE: [i16; 841] = [
36, 36, 68, 38, 44, 55, 51, 205, 206, 58, 108, 69, 70, 71, 72, 8, 185, 61, 77, 79, 17, -100, 113, 9, 246, 100, 174, 73, 66, 16, 76, 51, 109, 66, 66, 66, 66, 160, 161, 195, 78, 78, 175, 24, 25, 26, 8, 66, 56, 114, 127, 166, 59, 47, 201, 247, 66, 54, 10, 49, 233, 74, 107, -5, 120, 167, 62, 63, 162, 108, 202, 191, 192, 193, 121, 194, 134, 135, 136, 137, 138, 139, 140, 141, -45, 144, 145, 146, 147, 148, 149, 109, 153, 158, 122, 249, 101, 36, 195, 73, 44, 191, 192, 193, 124, 194, 228, 62, 125, 127, 128, 172, 129, 177, 150, 132, -67, 179, 180, 133, 181, 183, 184, 195, 195, 186, 153, 77, 195, 159, 164, 243, 244, 169, 195, -131, 250, 62, 188, 189, 94, 95, 254, 62, 96, 97, 98, 178, 197, 78, 195, 195, 209, 114, 220, 226, 224, 213, 263, 264, 234, 235, 236, 242, 239, 208, 95, 210, 245, 96, 97, 98, 252, 253, 17, 102, 256, 262, 18, 19, 8, 20, 1, 2, 3, 4, 5, 6, 9, 261, 21, 11, 22, 222, 223, 163, 23, 24, 25, 26, 15, 207, 227, 212, 225, 187, 27, 28, 29, 30, 230, 231, 232, 103, 241, 240, 255, 260, 265, 123, 32, 33, 34, 35, 17, 211, 229, 0, 18, 19, 8, 20, 0, 0, 0, 0, 0, 0, 9, 0, 21, 0, 22, 151, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 152, 33, 34, 35, 9, 171, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 50, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 32, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 75, 33, 34, 35, 9, 0, 21, 0, 50, 0, 0, 0, 23, 24, 25, 26, 0, 0, 0, 0, 0, 0, 27, 28, 29, 30, 17, 0, 0, 31, 18, 19, 8, 20, 0, 0, 75, 33, 34, 35, 9, 0, 21, 0, 22, 0, 0, 0, 23, 24, 25, 26, 117, 0, 0, 0, 0, 0, 27, 28, 29, 30, 0, 0, 0, 31, 0, 118, 0, 0, 0, 0, 32, 33, 143, 35, 198, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 199, 94, 95, 0, 0, 96, 97, 98, 217, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 131, 94, 95, 0, 0, 96, 97, 98, 165, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 126, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 204, 94, 95, 0, 0, 96, 97, 98, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 131, 94, 95, 0, 0, 96, 97, 98, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 214, 0, 96, 97, 98, 0, 0, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 215, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 80, 81, 82, 83, 84, 85, 86, 87, 88, 216, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 80, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 81, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 82, 83, 84, 85, 86, 87, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, -132, -132, -132, -132, -132, -132, 88, 0, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 89, 90, 91, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 92, 93, 0, 94, 95, 0, 0, 96, 97, 98, 
];

/// ???
pub const YY_CHECK: [i16; 841] = [
4, 5, 23, 4, 5, 12, 10, 164, 165, 12, 33, 27, 28, 29, 30, 15, 127, 21, 34, 35, 9, 30, 28, 23, 12, 41, 12, 31, 22, 55, 34, 35, 55, 27, 28, 29, 30, 27, 28, 150, 34, 35, 28, 32, 33, 34, 15, 41, 55, 55, 59, 12, 55, 0, 12, 43, 50, 33, 58, 57, 217, 57, 26, 0, 55, 26, 55, 56, 58, 33, 28, 19, 20, 21, 47, 23, 80, 81, 82, 83, 84, 85, 86, 87, 0, 89, 90, 91, 92, 93, 94, 55, 96, 97, 35, 43, 12, 101, 209, 103, 101, 19, 20, 21, 47, 23, 209, 55, 29, 59, 30, 115, 35, 117, 18, 30, 30, 121, 122, 30, 124, 125, 126, 234, 235, 129, 130, 143, 239, 55, 57, 234, 235, 11, 245, 11, 239, 55, 142, 143, 53, 54, 245, 55, 57, 58, 59, 47, 11, 143, 261, 262, 11, 55, 41, 28, 55, 178, 261, 262, 41, 41, 55, 28, 41, 169, 54, 171, 11, 57, 58, 59, 43, 43, 9, 10, 43, 17, 13, 14, 15, 16, 3, 4, 5, 6, 7, 8, 23, 12, 25, 1, 27, 197, 198, 101, 31, 32, 33, 34, 2, 166, 207, 177, 201, 130, 41, 42, 43, 44, 214, 215, 216, 48, 225, 223, 246, 255, 263, 58, 55, 56, 57, 58, 9, 174, 211, -1, 13, 14, 15, 16, -1, -1, -1, -1, -1, -1, 23, -1, 25, -1, 27, 28, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, 24, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, -1, -1, -1, -1, -1, -1, 41, 42, 43, 44, 9, -1, -1, 48, 13, 14, 15, 16, -1, -1, 55, 56, 57, 58, 23, -1, 25, -1, 27, -1, -1, -1, 31, 32, 33, 34, 12, -1, -1, -1, -1, -1, 41, 42, 43, 44, -1, -1, -1, 48, -1, 27, -1, -1, -1, -1, 55, 56, 57, 58, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, 12, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, 22, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 27, 53, 54, -1, -1, 57, 58, 59, -1, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, 28, 53, 54, -1, -1, 57, 58, 59, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, 30, -1, 57, 58, 59, -1, -1, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 37, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 38, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 39, 40, 41, 42, 43, 44, 45, -1, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 47, 48, 49, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 50, 51, -1, 53, 54, -1, -1, 57, 58, 59, 
];

/// `YY_R1[YYN]` - symbol number of symbol that rule YYN derives.
pub const YY_R1: [i8; 136] = [
0, 61, 62, 62, 62, 62, 62, 63, 62, 64, 64, 65, 65, 65, 66, 66, 66, 66, 67, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 66, 68, 68, 69, 69, 69, 70, 70, 71, 72, 72, 72, 72, 72, 73, 74, 74, 74, 75, 75, 75, 76, 77, 77, 78, 78, 79, 79, 79, 79, 80, 79, 82, 81, 83, 83, 84, 85, 85, 86, 86, 87, 88, 88, 89, 89, 90, 90, 90, 91, 92, 93, 93, 94, 95, 95, 96, 96, 97, 98, 97, 99, 97, 97, 100, 101, 97, 102, 103, 104, 104, 105, 105, 106, 107, 106, 108, 108, 109, 109, 110, 110, 111, 112, 112, 113, 113, 115, 114, 114, 116, 116, 
];

/// `YY_R2[YYN]` - number of symbols on the right hand side of rule YYN.
pub const YY_R2: [i8; 136] = [
0, 2, 2, 2, 2, 2, 2, 0, 3, 1, 1, 1, 1, 1, 4, 6, 4, 4, 0, 6, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 2, 4, 3, 4, 3, 1, 1, 1, 1, 3, 1, 3, 1, 4, 1, 3, 1, 4, 2, 2, 2, 2, 1, 2, 3, 3, 3, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 0, 4, 0, 3, 1, 2, 3, 1, 3, 1, 1, 2, 1, 2, 1, 3, 1, 1, 1, 2, 3, 1, 3, 2, 1, 3, 1, 3, 1, 0, 5, 0, 5, 3, 0, 0, 7, 2, 3, 1, 3, 1, 2, 1, 0, 4, 3, 2, 1, 3, 3, 4, 4, 1, 2, 1, 3, 0, 4, 1, 1, 2, 
];

/// Calls requested reduce action.
#[inline(always)]
pub fn reduce(parser: &mut Parser, rule_number: i16) -> Result<()> {
  match rule_number {
    4 => parser.action_name(), // feel: START_NAME NAME
    7 => parser.action_unary_tests_begin(), // $@1: %empty
    14 => parser.action_for(), // textual_expression: FOR iteration_contexts RETURN expression
    15 => parser.action_if(), // textual_expression: IF expression THEN expression ELSE expression
    16 => parser.action_some(), // textual_expression: SOME quantified_expressions SATISFIES expression
    17 => parser.action_every(), // textual_expression: EVERY quantified_expressions SATISFIES expression
    18 => parser.action_between_begin(), // $@2: %empty
    19 => parser.action_between(), // textual_expression: expression BETWEEN $@2 expression BETWEEN_AND expression
    20 => parser.action_disjunction(), // textual_expression: expression OR expression
    21 => parser.action_conjunction(), // textual_expression: expression AND expression
    22 => parser.action_comparison_eq(), // textual_expression: expression EQ expression
    23 => parser.action_comparison_nq(), // textual_expression: expression NQ expression
    24 => parser.action_comparison_lt(), // textual_expression: expression LT expression
    25 => parser.action_comparison_le(), // textual_expression: expression LE expression
    26 => parser.action_comparison_gt(), // textual_expression: expression GT expression
    27 => parser.action_comparison_ge(), // textual_expression: expression GE expression
    28 => parser.action_comparison_in(), // textual_expression: expression IN LEFT_PAREN comparison_in
    29 => parser.action_comparison_in(), // textual_expression: expression IN expression
    30 => parser.action_addition(), // textual_expression: expression PLUS expression
    31 => parser.action_subtraction(), // textual_expression: expression MINUS expression
    32 => parser.action_multiplication(), // textual_expression: expression MUL expression
    33 => parser.action_division(), // textual_expression: expression DIV expression
    34 => parser.action_exponentiation(), // textual_expression: expression EXP expression
    35 => parser.action_negation(), // textual_expression: MINUS expression
    36 => parser.action_instance_of(), // textual_expression: expression INSTANCE OF type
    37 => parser.action_path(), // textual_expression: expression DOT NAME
    38 => parser.action_filter(), // textual_expression: expression LEFT_BRACKET expression RIGHT_BRACKET
    42 => parser.action_name(), // textual_expression: NAME
    43 => parser.action_name_date_time(), // textual_expression: NAME_DATE_TIME
    47 => parser.action_unary_tests_irrelevant(), // unary_tests: MINUS
    48 => parser.action_unary_tests_negated(), // unary_tests: NOT LEFT_PAREN positive_unary_tests RIGHT_PAREN
    50 => parser.action_expression_list_tail(), // positive_unary_tests: expression COMMA positive_unary_tests
    51 => parser.action_expression_list_tail(), // positive_unary_tests: expression
    52 => parser.action_expression_list_tail(), // comparison_in: expression COMMA positive_unary_tests RIGHT_PAREN
    53 => parser.action_comparison_unary_lt(), // simple_positive_unary_test: LT endpoint
    54 => parser.action_comparison_unary_le(), // simple_positive_unary_test: LE endpoint
    55 => parser.action_comparison_unary_gt(), // simple_positive_unary_test: GT endpoint
    56 => parser.action_comparison_unary_ge(), // simple_positive_unary_test: GE endpoint
    58 => parser.action_interval(), // interval: interval_start interval_end
    59 => parser.action_interval_start(), // interval_start: LEFT_PAREN endpoint ELLIPSIS
    60 => parser.action_interval_start(), // interval_start: RIGHT_BRACKET endpoint ELLIPSIS
    61 => parser.action_interval_start(), // interval_start: LEFT_BRACKET endpoint ELLIPSIS
    62 => parser.action_interval_end(), // interval_end: endpoint RIGHT_PAREN
    63 => parser.action_interval_end(), // interval_end: endpoint LEFT_BRACKET
    64 => parser.action_interval_end(), // interval_end: endpoint RIGHT_BRACKET
    69 => parser.action_literal_null(), // literal: NULL
    70 => parser.action_literal_numeric(), // simple_literal: NUMERIC
    71 => parser.action_literal_string(), // simple_literal: STRING
    72 => parser.action_literal_boolean(), // simple_literal: BOOLEAN
    73 => parser.action_literal_at(), // simple_literal: AT STRING
    74 => parser.action_literal_date_time(), // $@3: %empty
    76 => parser.action_context_begin(), // $@4: %empty
    77 => parser.action_context_end(), // context: LEFT_BRACE $@4 context_entries
    78 => parser.action_empty_context(), // context_entries: RIGHT_BRACE
    79 => parser.action_context_entry_tail(), // context_entries: context_entry context_entry_tail
    80 => parser.action_context_entry(), // context_entry: key COLON expression
    82 => parser.action_context_entry_tail(), // context_entry_tail: COMMA context_entry context_entry_tail
    83 => parser.action_key_name(), // key: NAME
    84 => parser.action_key_string(), // key: STRING
    85 => parser.action_list(), // list: LEFT_BRACKET list_items
    86 => parser.action_list_empty(), // list_items: RIGHT_BRACKET
    87 => parser.action_list_tail(), // list_items: expression list_tail
    89 => parser.action_list_tail(), // list_tail: COMMA expression list_tail
    90 => parser.action_function_invocation_no_parameters(), // parameters: RIGHT_PAREN
    91 => parser.action_function_invocation(), // parameters: named_parameters
    92 => parser.action_function_invocation(), // parameters: positional_parameters
    93 => parser.action_named_parameters_tail(), // named_parameters: named_parameter named_parameters_tail
    94 => parser.action_named_parameter(), // named_parameter: NAME COLON expression
    96 => parser.action_named_parameters_tail(), // named_parameters_tail: COMMA named_parameter named_parameters_tail
    97 => parser.action_positional_parameters_tail(), // positional_parameters: expression positional_parameters_tail
    99 => parser.action_positional_parameters_tail(), // positional_parameters_tail: COMMA expression positional_parameters_tail
    100 => parser.action_name(), // qualified_name: NAME
    103 => parser.action_type_name(), // $@5: %empty
    104 => parser.action_list_type(), // type: LIST $@5 LT type GT
    105 => parser.action_type_name(), // $@6: %empty
    106 => parser.action_range_type(), // type: RANGE $@6 LT type GT
    108 => parser.action_type_name(), // $@7: %empty
    109 => parser.action_type_name(), // $@8: %empty
    110 => parser.action_function_type(), // type: FUNCTION $@7 LT function_type_parameters $@8 RIGHT_ARROW type
    111 => parser.action_context_type_entry_tail(), // context_type_entries: context_type_entry context_type_entry_tail
    112 => parser.action_context_type_entry(), // context_type_entry: NAME COLON type
    114 => parser.action_context_type_entry_tail(), // context_type_entry_tail: COMMA context_type_entry context_type_entry_tail
    115 => parser.action_function_type_parameters_empty(), // function_type_parameters: GT
    116 => parser.action_function_type_parameters_tail(), // function_type_parameters: type function_type_parameters_tail
    118 => parser.action_type_name(), // $@9: %empty
    119 => parser.action_function_type_parameters_tail(), // function_type_parameters_tail: $@9 COMMA type function_type_parameters_tail
    126 => parser.action_function_definition(), // function_definition: FUNCTION LEFT_PAREN formal_parameters external
    127 => parser.action_function_formal_parameters_empty(), // formal_parameters: RIGHT_PAREN
    128 => parser.action_function_formal_parameters_tail(), // formal_parameters: formal_parameter formal_parameters_tail
    130 => parser.action_function_formal_parameters_tail(), // formal_parameters_tail: COMMA formal_parameter formal_parameters_tail
    131 => parser.action_type_name(), // $@10: %empty
    132 => parser.action_function_formal_parameter_with_type(), // formal_parameter: NAME $@10 COLON type
    133 => parser.action_function_formal_parameter_no_type(), // formal_parameter: NAME
    134 => parser.action_function_body(), // external: expression
    135 => parser.action_function_body_external(), // external: EXTERNAL expression
    _ => Ok(())
  }
}
