/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::accept;
use crate::dmntk_feel::values::Value;
use crate::lalr::TokenType::StartTextualExpressions;
use dmntk_feel::{scope, value_null, Scope};

#[test]
fn _0001() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpressions,
    r#"1,2,3"#,
    r#"
       ExpressionList
       ├─ Numeric
       │  └─ `1.`
       ├─ Numeric
       │  └─ `2.`
       └─ Numeric
          └─ `3.`
    "#,
    false,
  );
}

#[test]
fn _0002() {
  let scope = scope!();
  scope.set_entry(&"a".into(), value_null!());
  scope.set_entry(&"b".into(), value_null!());
  scope.set_entry(&"c".into(), value_null!());
  accept(
    &scope,
    StartTextualExpressions,
    r#"a,b,c"#,
    r#"
       ExpressionList
       ├─ Name
       │  └─ `a`
       ├─ Name
       │  └─ `b`
       └─ Name
          └─ `c`
    "#,
    false,
  );
}

#[test]
fn _0003() {
  let scope = scope!();
  scope.set_entry(&"a".into(), value_null!());
  scope.set_entry(&"b".into(), value_null!());
  scope.set_entry(&"c".into(), value_null!());
  accept(
    &scope,
    StartTextualExpressions,
    r#"a+b,b-c,c**a,(["a","b","c"])"#,
    r#"
       ExpressionList
       ├─ Add
       │  ├─ Name
       │  │  └─ `a`
       │  └─ Name
       │     └─ `b`
       ├─ Sub
       │  ├─ Name
       │  │  └─ `b`
       │  └─ Name
       │     └─ `c`
       ├─ Exp
       │  ├─ Name
       │  │  └─ `c`
       │  └─ Name
       │     └─ `a`
       └─ List
          ├─ String
          │  └─ `a`
          ├─ String
          │  └─ `b`
          └─ String
             └─ `c`
    "#,
    false,
  );
}
