/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! Additional test for expressions found in compliance tests.

use super::accept;
use crate::lalr::TokenType::{List, StartTextualExpression};
use crate::parser::Parser;
use dmntk_feel::context::FeelContext;
use dmntk_feel::values::Value;
use dmntk_feel::{scope, value_number, FeelNumber, Scope};

#[test]
fn _0001() {
  let scope = scope!();
  let mut ctx_1 = FeelContext::default();
  ctx_1.set_entry(&"principal".into(), value_number!(60000));
  ctx_1.set_entry(&"rate".into(), value_number!(375, 4));
  ctx_1.set_entry(&"termMonths".into(), value_number!(360));
  scope.set_entry(&"loan".into(), Value::Context(ctx_1));
  accept(
    &scope,
    StartTextualExpression,
    r#"(loan.principal*loan.rate/12)/(1-(1+loan.rate/12)**-loan.termMonths)"#,
    r#"
       Div
       ├─ Div
       │  ├─ Mul
       │  │  ├─ Path
       │  │  │  ├─ Name
       │  │  │  │  └─ `loan`
       │  │  │  └─ Name
       │  │  │     └─ `principal`
       │  │  └─ Path
       │  │     ├─ Name
       │  │     │  └─ `loan`
       │  │     └─ Name
       │  │        └─ `rate`
       │  └─ Numeric
       │     └─ `12.`
       └─ Sub
          ├─ Numeric
          │  └─ `1.`
          └─ Exp
             ├─ Add
             │  ├─ Numeric
             │  │  └─ `1.`
             │  └─ Div
             │     ├─ Path
             │     │  ├─ Name
             │     │  │  └─ `loan`
             │     │  └─ Name
             │     │     └─ `rate`
             │     └─ Numeric
             │        └─ `12.`
             └─ Neg
                └─ Path
                   ├─ Name
                   │  └─ `loan`
                   └─ Name
                      └─ `termMonths`
    "#,
    false,
  );
}

/// Tests how the parser behaves, when invalid starting point is given.
#[test]
fn _0002() {
  let scope = scope!();
  assert!(Parser::new(&scope, List, "[1,2,3]", false).parse().is_err());
}
