/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::test::Bencher;
use crate::dmntk_feel::values::Value;
use crate::lalr::TokenType::StartTextualExpression;
use crate::parser::Parser;
use dmntk_feel::{scope, value_null, Scope};

#[bench]
fn _0001(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"some n in [1,2,3] satisfies n > 1.5"#;
  b.iter(|| Parser::new(&scope, StartTextualExpression, input, false).parse());
}

#[bench]
fn _0002(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"some n in [1,2,3], m in <= 100 satisfies n > 1.5 * m"#;
  b.iter(|| Parser::new(&scope, StartTextualExpression, input, false).parse());
}

#[bench]
fn _0003(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"every n in [1,2,3] satisfies n > 1.5"#;
  b.iter(|| Parser::new(&scope, StartTextualExpression, input, false).parse());
}

#[bench]
fn _0004(b: &mut Bencher) {
  let scope = scope!();
  scope.set_entry(&"n".into(), value_null!());
  scope.set_entry(&"m".into(), value_null!());
  let input = r#"every n in [1,2,3], m in <= 100 satisfies n > 1.5 * m"#;
  b.iter(|| Parser::new(&scope, StartTextualExpression, input, false).parse());
}
