/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::accept;
use crate::lalr::TokenType::StartTextualExpression;
use dmntk_feel::values::Value;
use dmntk_feel::{scope, value_null, Scope};

#[test]
fn _0001() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpression,
    "if 1 > 2 then 5 else 8",
    r#"
       If
       ├─ Gt
       │  ├─ Numeric
       │  │  └─ `1.`
       │  └─ Numeric
       │     └─ `2.`
       ├─ Numeric
       │  └─ `5.`
       └─ Numeric
          └─ `8.`
    "#,
    false,
  );
}

#[test]
fn _0002() {
  let scope = scope!();
  scope.set_entry(&"a".into(), value_null!());
  scope.set_entry(&"b".into(), value_null!());
  accept(
    &scope,
    StartTextualExpression,
    "if a > b then a else b",
    r#"
       If
       ├─ Gt
       │  ├─ Name
       │  │  └─ `a`
       │  └─ Name
       │     └─ `b`
       ├─ Name
       │  └─ `a`
       └─ Name
          └─ `b`
    "#,
    false,
  );
}
