/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::accept;
use crate::lalr::TokenType::StartTextualExpression;
use dmntk_feel::{scope, Scope};

#[test]
fn _0001() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpression,
    "[1,2,3][2]",
    r#"
       Filter
       ├─ List
       │  ├─ Numeric
       │  │  └─ `1.`
       │  ├─ Numeric
       │  │  └─ `2.`
       │  └─ Numeric
       │     └─ `3.`
       └─ Numeric
          └─ `2.`
    "#,
    false,
  );
}

#[test]
fn _0002() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpression,
    "EmployeeTable[name=LastName]",
    r#"
       Filter
       ├─ Name
       │  └─ `EmployeeTable`
       └─ Eq
          ├─ Name
          │  └─ `name`
          └─ Name
             └─ `LastName`
    "#,
    false,
  );
}

#[test]
fn _0003() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpression,
    "EmployeeTable[1].deptNum",
    r#"
       Path
       ├─ Filter
       │  ├─ Name
       │  │  └─ `EmployeeTable`
       │  └─ Numeric
       │     └─ `1.`
       └─ Name
          └─ `deptNum`
    "#,
    false,
  );
}

#[test]
fn _0004() {
  let scope = scope!();
  accept(
    &scope,
    StartTextualExpression,
    "DeptTable[number=EmployeeTable[name=LastName].deptNum[1]].manager[1]",
    r#"
       Filter
       ├─ Path
       │  ├─ Filter
       │  │  ├─ Name
       │  │  │  └─ `DeptTable`
       │  │  └─ Eq
       │  │     ├─ Name
       │  │     │  └─ `number`
       │  │     └─ Filter
       │  │        ├─ Path
       │  │        │  ├─ Filter
       │  │        │  │  ├─ Name
       │  │        │  │  │  └─ `EmployeeTable`
       │  │        │  │  └─ Eq
       │  │        │  │     ├─ Name
       │  │        │  │     │  └─ `name`
       │  │        │  │     └─ Name
       │  │        │  │        └─ `LastName`
       │  │        │  └─ Name
       │  │        │     └─ `deptNum`
       │  │        └─ Numeric
       │  │           └─ `1.`
       │  └─ Name
       │     └─ `manager`
       └─ Numeric
          └─ `1.`
    "#,
    false,
  );
}
