/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::accept;
use crate::lalr::TokenType::*;
use dmntk_feel::values::Value;
use dmntk_feel::{scope, value_null, Scope};

#[test]
fn _0001() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{}"#,
    r#"
       Context
       └─ (empty)
    "#,
    false,
  );
}

#[test]
fn _0002() {
  let scope = scope!();
  accept(
    &scope,
    StartBoxedExpression,
    " \n { \t } \r ",
    r#"
       Context
       └─ (empty)
    "#,
    false,
  );
}

#[test]
fn _0003() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{age:49}"#,
    r#"
       Context
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `age`
          └─ Numeric
             └─ `49.`
    "#,
    false,
  );
}

#[test]
fn _0004() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{"age":49}"#,
    r#"
       Context
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `age`
          └─ Numeric
             └─ `49.`
    "#,
    false,
  );
}

#[test]
fn _0005() {
  let scope = scope!();
  accept(
    &scope,
    StartBoxedExpression,
    r#"{Birth_date: date("1956-07-11")}"#,
    r#"
       Context
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `Birth_date`
          └─ FunctionInvocation
             ├─ Name
             │  └─ `date`
             └─ PositionalParameters
                └─ String
                   └─ `1956-07-11`
    "#,
    false,
  );
}

#[test]
fn _0006() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{name:"Dariusz",age:49}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `name`
       │  └─ String
       │     └─ `Dariusz`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `age`
          └─ Numeric
             └─ `49.`
    "#,
    false,
  );
}

#[test]
fn _0007() {
  let scope = scope!();
  accept(
    &scope,
    StartBoxedExpression,
    r#"{"name": "Dariusz", "age": 49}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `name`
       │  └─ String
       │     └─ `Dariusz`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `age`
          └─ Numeric
             └─ `49.`
    "#,
    false,
  );
}

#[test]
fn _0008() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{name:"Dariusz",age:49,car:{model:"Skoda",production year:2016}}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `name`
       │  └─ String
       │     └─ `Dariusz`
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `age`
       │  └─ Numeric
       │     └─ `49.`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `car`
          └─ Context
             ├─ ContextEntry
             │  ├─ ContextEntryKey
             │  │  └─ `model`
             │  └─ String
             │     └─ `Skoda`
             └─ ContextEntry
                ├─ ContextEntryKey
                │  └─ `production year`
                └─ Numeric
                   └─ `2016.`
    "#,
    false,
  );
}

#[test]
fn _0009() {
  let scope = scope!();
  accept(
    &scope,
    StartBoxedExpression,
    r#"{"name":"Dariusz","age":49,"car":{"model":"Skoda","production year":2016}}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `name`
       │  └─ String
       │     └─ `Dariusz`
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `age`
       │  └─ Numeric
       │     └─ `49.`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `car`
          └─ Context
             ├─ ContextEntry
             │  ├─ ContextEntryKey
             │  │  └─ `model`
             │  └─ String
             │     └─ `Skoda`
             └─ ContextEntry
                ├─ ContextEntryKey
                │  └─ `production year`
                └─ Numeric
                   └─ `2016.`
    "#,
    false,
  );
}

#[test]
fn _00010() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{ a: 1, b: 2, c: 1 + 2}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `a`
       │  └─ Numeric
       │     └─ `1.`
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `b`
       │  └─ Numeric
       │     └─ `2.`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `c`
          └─ Add
             ├─ Numeric
             │  └─ `1.`
             └─ Numeric
                └─ `2.`
    "#,
    false,
  );
}

#[test]
fn _00011() {
  let scope = scope!();
  scope.set_entry(&"d".into(), value_null!());
  scope.set_entry(&"e".into(), value_null!());
  accept(
    &scope,
    StartContext,
    r#"{ a: 1, b: 2, c: d + e}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `a`
       │  └─ Numeric
       │     └─ `1.`
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `b`
       │  └─ Numeric
       │     └─ `2.`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `c`
          └─ Add
             ├─ Name
             │  └─ `d`
             └─ Name
                └─ `e`
    "#,
    false,
  );
}

#[test]
fn _00012() {
  let scope = scope!();
  accept(
    &scope,
    StartContext,
    r#"{ a: 1, b: 2, c: a + b}"#,
    r#"
       Context
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `a`
       │  └─ Numeric
       │     └─ `1.`
       ├─ ContextEntry
       │  ├─ ContextEntryKey
       │  │  └─ `b`
       │  └─ Numeric
       │     └─ `2.`
       └─ ContextEntry
          ├─ ContextEntryKey
          │  └─ `c`
          └─ Add
             ├─ Name
             │  └─ `a`
             └─ Name
                └─ `b`
    "#,
    false,
  );
}
