/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL parser.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::{accept, empty_scope};
use crate::lalr::TokenType::StartTextualExpression;
use dmntk_feel::values::VALUE_NULL;

#[test]
fn test_instance_of_1() {
  let scope = &mut empty_scope();
  scope.set_entry(&"Person".into(), VALUE_NULL);
  accept(
    scope,
    StartTextualExpression,
    "Person instance of number",
    r#"
        InstanceOf
          Name
            `Person`
          Number
      "#,
    false,
  );
}

#[test]
fn test_instance_of_2() {
  let scope = &mut empty_scope();
  scope.set_entry(&"Person".into(), VALUE_NULL);
  accept(
    scope,
    StartTextualExpression,
    "Person instance of function<string>->string",
    r#"
        InstanceOf
          Name
            `Person`
          Function([String], String)
      "#,
    false,
  );
}
