/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_0001() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, "1-1", 0, 0);
}

#[test]
fn test_0002() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, " 1 - 2 ", -1, 0);
}

#[test]
fn test_0003() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, " 5 -2 -1 ", 2, 0);
}

#[test]
fn test_0004() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, "1000-200-2", 798, 0);
}

#[test]
fn test_0005() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, "( 1 - 2 ) - ( 3 - 4 )", 0, 0);
}

#[test]
fn test_0006() {
  let scope = &te_scope(r#"{}"#);
  te_number(false, scope, "( ( ( 4 - 3 ) ) )", 1, 0);
}

#[test]
fn test_0007() {
  let scope = &te_scope("{ a: 11.2, b: 0.2}");
  te_number(false, scope, "a-b", 11, 0);
}

#[test]
fn test_0008() {
  let scope = &te_scope("{ a: 11.2, b: 0.2, c: 5.351 }");
  te_number(false, scope, "a-b-c", 5649, 3);
}

#[test]
fn test_0009() {
  let scope = &te_scope("{ a: 11.2, b: 0.2, c: 5.351 }");
  te_number(false, scope, " a  \n -  b \n  -  c", 5649, 3);
}
