/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_at_literal() {
  let scope = &te_scope(r#"{}"#);
  te_value(false, scope, r#"@"2021-01-28""#, r#"date("2021-01-28")"#);
  te_value(false, scope, r#"@"2021-01-28T19:15:00""#, r#"date and time("2021-01-28T19:15:00")"#);
  te_value(false, scope, r#"@"-PT1H""#, r#"duration("-PT1H")"#);
  te_value(false, scope, r#"@"P2Y""#, r#"duration("P2Y")"#);
}
