/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_list() {
  let scope = &te_scope("{}");
  satisfies(false, scope, "1", "", "[]", false);
  satisfies(false, scope, "1", "", "[1]", true);
  satisfies(false, scope, "10", "", "[9,10,11]", true);
  satisfies(false, scope, "8", "", "[9,10,11]", false);
  satisfies(false, scope, "12", "", "[9,10,11]", false);
  satisfies(false, scope, "10", "", "[9],[10],[11]", true);
  satisfies(false, scope, "8", "", "[9],[10],[11]", false);
  satisfies(false, scope, "12", "", "[9],[10],[11]", false);
}
