/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{te_number, te_scope, te_string};

#[test]
fn _0001() {
  let scope = &te_scope(r#"{N:9}"#);
  te_number(false, scope, r#"if N < 10 then 1 else 2"#, 1, 0);
}

#[test]
fn _0002() {
  let scope = &te_scope(r#"{N:10}"#);
  te_number(false, scope, r#"if N < 10 then 1 else 2"#, 2, 0);
}

#[test]
fn _0003() {
  let scope = &te_scope(r#"{aDate: @"2017-01-02", aString: "Hello World"}"#);
  te_string(
    false,
    scope,
    r#"if aDate > date("2017-01-01") then substring before(aString, " ") else substring after(aString, " ")"#,
    r#"Hello"#,
  );
}

#[test]
fn _0004() {
  let scope = &te_scope(r#"{aDate: @"2017-01-01", aString: "Hello World"}"#);
  te_string(
    false,
    scope,
    r#"if aDate > date("2017-01-01") then substring before(aString, " ") else substring after(aString, " ")"#,
    r#"World"#,
  );
}
