/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::super::*;

#[test]
fn _0001() {
  let scope = &te_scope("{}");
  te_time(false, scope, r#"time(11,59,45,null)"#, FeelTime::local(11, 59, 45, 0));
}

#[test]
fn _0002() {
  let scope = &te_scope(r#"{Hours:12,Minutes:59,Seconds:1.3,Timezone:@"-PT1H"}"#);
  te_time(
    false,
    scope,
    r#"time(Hours,Minutes,Seconds,Timezone)"#,
    FeelTime::new_hmso_opt(12, 59, 1, 300_000_000, -3600).unwrap(),
  );
}

#[test]
fn test_time() {
  let scope = &te_scope("{}");
  te_time(false, scope, r#"time("23:59:00")"#, FeelTime::local(23, 59, 0, 0));
  te_time(false, scope, r#"  time  (  "23:59:00"         )   "#, FeelTime::local(23, 59, 0, 0));
  te_time(false, scope, r#"time("23:59:00Z")"#, FeelTime::utc(23, 59, 0, 0));
  te_time(false, scope, r#"time("23:59:00z")"#, FeelTime::utc(23, 59, 0, 0));
  te_time(false, scope, r#"time("11:22:33-00:00")"#, FeelTime::utc(11, 22, 33, 0));
  te_time(false, scope, r#"time("11:22:33+00:00")"#, FeelTime::utc(11, 22, 33, 0));
  te_time(false, scope, r#"time(time("11:00:00"))"#, FeelTime::local(11, 0, 0, 0));
  te_time(false, scope, r#"time(date and time("2019-12-06T18:34:12"))"#, FeelTime::local(18, 34, 12, 0));
  te_time(false, scope, r#"time(date and time("2019-12-06T11:00:00Z"))"#, FeelTime::utc(11, 0, 0, 0));
  te_time(false, scope, r#"time(date and time("2019-12-06T11:00:00z"))"#, FeelTime::utc(11, 0, 0, 0));
  te_time(false, scope, r#"time(date("2019-12-06"))"#, FeelTime::utc(0, 0, 0, 0));
  te_bool(false, scope, r#"time("12:21:12") in [time("12:21:12")..time("12:21:12")]"#, true);
  te_bool(false, scope, r#"time("12:21:11") in [time("12:21:12")..time("12:21:12")]"#, false);
  te_bool(false, scope, r#"time("12:21:13") in [time("12:21:12")..time("12:21:12")]"#, false);
  te_bool(false, scope, r#"time("12:21:12") in (time("12:21:11")..time("12:21:13"))"#, true);
  te_null(false, scope, r#"time("22:63:12")"#, "time_1");
  te_null(false, scope, r#"time("22:10:12+15:00")"#, "time_1");
  te_null(false, scope, r#"time("22:10:12-15:00")"#, "time_1");
  te_null(false, scope, r#"time(24,59,45,null)"#, "time_4");
  te_null(false, scope, r#"time(23,60,45,null)"#, "time_4");
  te_null(false, scope, r#"time(23,59,60,null)"#, "time_4");
  te_null(false, scope, r#"time(-12,12,12,null)"#, "time_4");
  te_null(false, scope, r#"time(12,-12,12,null)"#, "time_4");
  te_null(false, scope, r#"time(12,12,-12,null)"#, "time_4");
}
