/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::tests::{te_be_value, te_scope};

#[test]
fn _0001() {
  let scope = &te_scope(r#"{}"#);
  te_be_value(
    false,
    scope,
    r#"get entries({key1: "value1", key2: "value2"})"#,
    r#"[{key: "key1", value: "value1"},{key: "key2", value: "value2"}]"#,
  );
}

#[test]
fn _0002() {
  let scope = &te_scope(r#"{}"#);
  te_be_value(
    false,
    scope,
    r#"get entries(m: {key1: "value1", key2: "value2"})"#,
    r#"[{key: "key1", value: "value1"},{key: "key2", value: "value2"}]"#,
  );
}
