/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_range() {
  let scope = &te_scope("{}");
  te_bool(false, scope, "2 in [1..5]", true);
  te_bool(false, scope, "0 in [1..5]", false);
  te_bool(false, scope, "6 in [1..5]", false);
  te_bool(false, scope, "1 in [1..5]", true);
  te_bool(false, scope, "5 in [1..5]", true);
  te_bool(false, scope, "1 in (1..5]", false);
  te_bool(false, scope, "5 in [1..5)", false);
  te_bool(false, scope, "1 in (1..5)", false);
  te_bool(false, scope, "1.01 in (1..5)", true);
  te_bool(false, scope, "5 in (1..5)", false);
  te_bool(false, scope, "4.99 in (1..5)", true);
  te_bool(false, scope, "1 in ]1..5]", false);
  te_bool(false, scope, "5 in [1..5[", false);
  te_bool(false, scope, "1 in ]1..5[", false);
  te_bool(false, scope, "5 in ]1..5[", false);
  te_bool(false, scope, "1 in [1..5] and 5 in [1..5]", true);
  te_bool(false, scope, "1 in [1..5] or 6 in [1..5]", true);
}
