/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::super::*;

#[test]
fn _0001() {
  let scope = &te_scope("{}");
  te_number(false, scope, "abs(1)", 1, 0);
}

#[test]
fn _0002() {
  let scope = &te_scope("{}");
  te_number(false, scope, "abs(-1)", 1, 0);
}

#[test]
fn _0003() {
  let scope = &te_scope("{}");
  te_number(false, scope, "abs(n:-34)", 34, 0);
}

#[test]
fn _0004() {
  let scope = &te_scope("{}");
  te_null(false, scope, "abs(number:-34)", r#"parameter 'n' not found"#);
}

#[test]
fn _0005() {
  let scope = &te_scope("{ Order size: -4.5 }");
  te_number(false, scope, "abs(Order size)", 45, 1);
}

#[test]
fn _0006() {
  let scope = &te_scope("{}");
  te_null(
    false,
    scope,
    r#"abs(duration("-P1D"))"#,
    r#"invalid argument type, expected number, actual type is days and time duration"#,
  );
}
