/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! `FEEL` expressions evaluator.

#![feature(test)]

extern crate dmntk_common;
extern crate dmntk_feel;
extern crate dmntk_feel_parser;
#[macro_use]
extern crate lazy_static;
extern crate regex;
#[macro_use]
extern crate thiserror;

#[cfg(test)]
mod benches;
mod bifs;
mod builders;
mod errors;
mod evaluators;
mod iterations;
#[cfg(test)]
mod tests;

pub use crate::evaluators::{evaluate, evaluate_context, evaluate_equals, evaluate_max, evaluate_min, evaluate_node_type, evaluate_sum, prepare};
