use dmntk_common::DmntkError;

/// Errors related to `FEEL` expression evaluator.
#[derive(Error, Debug)]
pub enum FeelEvaluatorError {
  #[error("expected FEEL context as an input")]
  NotAContext,
  #[error("expected positional or named parameter")]
  ExpectedPositionalOrNamedParameter,
  #[error("expected AstNode::ParameterName, actual node is {0}")]
  ExpectedAstNodeParameterName(String),
  #[error("expected AST node {0}, actual AST node is {1}")]
  ExpectedAstNode(String, String),
  #[error("unexpected AST node in evaluator builder {0}")]
  UnexpectedAstNode(String),
}

impl From<FeelEvaluatorError> for DmntkError {
  fn from(e: FeelEvaluatorError) -> Self {
    DmntkError::new("FeelEvaluatorError", &format!("{}", e))
  }
}

pub fn err_not_a_context() -> DmntkError {
  FeelEvaluatorError::NotAContext.into()
}

pub fn err_expected_positional_or_named_parameter() -> DmntkError {
  FeelEvaluatorError::ExpectedPositionalOrNamedParameter.into()
}

pub fn err_expected_ast_node_parameter_name(s: &str) -> DmntkError {
  FeelEvaluatorError::ExpectedAstNodeParameterName(s.to_string()).into()
}

pub fn err_expected_ast_node(expected: &str, actual: &str) -> DmntkError {
  FeelEvaluatorError::ExpectedAstNode(expected.to_string(), actual.to_string()).into()
}

pub fn err_unexpected_ast_node(s: &str) -> DmntkError {
  FeelEvaluatorError::UnexpectedAstNode(s.to_string()).into()
}
