use super::test::Bencher;
use crate::builders::build_evaluator;
use dmntk_feel::values::Value;
use dmntk_feel::{scope, value_null, value_number, FeelNumber, Scope};

#[bench]
fn bench_0001(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"2-1"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  let evaluator = build_evaluator(&node).unwrap();
  assert_eq!(value_number!(1), evaluator(&scope));
  b.iter(|| evaluator(&scope));
}

#[bench]
fn bench_0001_old(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"2-1"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  assert_eq!(value_number!(1), crate::evaluate(&scope, &node).unwrap());
  b.iter(|| crate::evaluate(&scope, &node).unwrap());
}

#[bench]
fn bench_0002(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"5-2-1"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  let evaluator = build_evaluator(&node).unwrap();
  assert_eq!(value_number!(2), evaluator(&scope));
  b.iter(|| evaluator(&scope));
}

#[bench]
fn bench_0002_old(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"5-2-1"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  assert_eq!(value_number!(2), crate::evaluate(&scope, &node).unwrap());
  b.iter(|| crate::evaluate(&scope, &node).unwrap());
}

#[bench]
fn bench_0003(b: &mut Bencher) {
  let scope = scope!();
  scope.set_entry(&"a".into(), value_null!());
  scope.set_entry(&"b".into(), value_null!());
  let input = r#"a-b"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  let evaluator = build_evaluator(&node).unwrap();
  scope.set_entry(&"a".into(), value_number!(18));
  scope.set_entry(&"b".into(), value_number!(3));
  assert_eq!(value_number!(15), evaluator(&scope));
  b.iter(|| evaluator(&scope));
}

#[bench]
fn bench_0003_old(b: &mut Bencher) {
  let scope = scope!();
  scope.set_entry(&"a".into(), value_null!());
  scope.set_entry(&"b".into(), value_null!());
  let input = r#"a-b"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  scope.set_entry(&"a".into(), value_number!(18));
  scope.set_entry(&"b".into(), value_number!(3));
  assert_eq!(value_number!(15), crate::evaluate(&scope, &node).unwrap());
  b.iter(|| crate::evaluate(&scope, &node).unwrap());
}
