/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;
use dmntk_feel::FeelDateTime;

#[test]
fn test_0002() {
  let scope = &te_scope("{}");
  te_null(false, scope, r#"date and time(null)"#, "date_and_time");
}

#[test]
fn test_0003() {
  let scope = &te_scope("{}");
  te_date_time_local(
    false,
    scope,
    r#"date and time(date:date("2017-01-01"),time:time("23:59:01"))"#,
    (2017, 1, 1),
    (23, 59, 1, 0),
  );
}

#[test]
fn test_0001() {
  let scope = &te_scope("{}");
  te_date_time_local(false, scope, r#"date and time("2012-12-24")"#, (2012, 12, 24), (0, 0, 0, 0));
  te_date_time(
    false,
    scope,
    r#"date and time("2012-12-24T23:59:00")"#,
    FeelDateTime::local(2012, 12, 24, 23, 59, 0, 0),
  );
  te_date_time(
    false,
    scope,
    "date    and  \n \t  time  ( \"2012-12-24T23:59:00\"  )   ",
    FeelDateTime::local(2012, 12, 24, 23, 59, 0, 0),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("-2017-02-28T02:02:02")"#,
    FeelDateTime::local(-2017, 2, 28, 2, 2, 2, 0),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("-2016-01-30T09:05:00")"#,
    FeelDateTime::local(-2016, 1, 30, 9, 5, 0, 0),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2015-12-31T23:59:59.9999999")"#,
    FeelDateTime::local(2015, 12, 31, 23, 59, 59, 999_999_900),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2018-10-01T12:32:59.111111")"#,
    FeelDateTime::local(2018, 10, 1, 12, 32, 59, 111_111_000),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2018-10-01T12:32:59.123123123123")"#,
    FeelDateTime::local(2018, 10, 1, 12, 32, 59, 123_123_123),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2012-12-24T23:59:00Z")"#,
    FeelDateTime::utc(2012, 12, 24, 23, 59, 0, 0),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2012-12-24T23:59:00z")"#,
    FeelDateTime::utc(2012, 12, 24, 23, 59, 0, 0),
  );
  te_date_time(
    false,
    scope,
    r#"date and time("2016-12-24T23:59:00-08:00")"#,
    FeelDateTime::utc(2016, 12, 25, 7, 59, 0, 0),
  );
  te_bool(
    false,
    scope,
    r#"date and time("2012-12-24T23:59:00") in [date and time("2012-12-24T23:59:00")..date and time("2012-12-24T23:59:00")]"#,
    true,
  );
  te_string(false, scope, r#"string(date and time("2016-12-24T23:59:00"))"#, "2016-12-24T23:59:00");
  te_string(false, scope, r#"string(date and time("2016-12-24T23:59:00Z"))"#, "2016-12-24T23:59:00Z");
  te_string(false, scope, r#"string(date and time("2016-12-24T23:59:00z"))"#, "2016-12-24T23:59:00Z");
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00-08:00"))"#,
    "2016-12-24T23:59:00-08:00",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00+02:12"))"#,
    "2016-12-24T23:59:00+02:12",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00+14:59"))"#,
    "2016-12-24T23:59:00+14:59",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00-14:59"))"#,
    "2016-12-24T23:59:00-14:59",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00@Etc/UTC"))"#,
    "2016-12-24T23:59:00@Etc/UTC",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("2016-12-24T23:59:00@Europe/Warsaw"))"#,
    "2016-12-24T23:59:00@Europe/Warsaw",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("999999999-12-31T23:59:59.999999999@Europe/Paris"))"#,
    "999999999-12-31T23:59:59.999999999@Europe/Paris",
  );
  te_string(
    false,
    scope,
    r#"string(date and time("999999999-12-31T23:59:59.999999999@Europe/Paris"))"#,
    "999999999-12-31T23:59:59.999999999@Europe/Paris",
  );
  let scope = &te_scope(r#"{dateTimeString:"2016-12-24T23:59:00-08:00"}"#);
  te_string(false, scope, r#"string(date and time(dateTimeString))"#, "2016-12-24T23:59:00-08:00");
  te_null(false, scope, r#"date and time("2012-13-24T23:59:00")"#, "date_and_time");
  te_null(false, scope, r#"date and time("2012-12-24T13:65:00")"#, "date_and_time");
  te_null(false, scope, r#"date and time("2016-12-24T23:59:00+25:00")"#, "date_and_time");
  te_null(false, scope, r#"date and time("2016-12-24T23:59:00-27:30")"#, "date_and_time");
  te_null(false, scope, r#"date and time("2017-12-31T13:20:00@xyz/abc")"#, "date_and_time");
}
