/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_0001() {
  let scope = &te_scope("{}");
  te_number(
    false,
    scope,
    r#"  1  // eol comment
         + 1"#,
    2,
    0,
  );
}

#[test]
fn test_0002() {
  let scope = &te_scope("{}");
  te_number(
    false,
    scope,
    r#" 1
          /*
          some intro waffle
          */
          + 1"#,
    2,
    0,
  );
}

#[test]
fn test_0003() {
  let scope = &te_scope("{}");
  te_number(false, scope, r#"1 + /* 1 + */ 1"#, 2, 0);
}

#[test]
fn test_0004() {
  let scope = &te_scope("{}");
  te_number(
    false,
    scope,
    r#" 1
          /*
          some intro waffle
          */
          + 1 // and stuff
          + 2"#,
    4,
    0,
  );
}
