/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::super::*;

#[test]
fn _0001() {
  let scope = &te_scope(r#"{}"#);
  te_date(false, scope, r#"date("2012-12-25")"#, 2012, 12, 25);
  te_number(false, scope, r#"date("2012-12-25").day"#, 25, 0);
  te_number(false, scope, r#"date("2012-12-25").month"#, 12, 0);
  te_number(false, scope, r#"date("2012-12-25").year"#, 2012, 0);
}

#[test]
fn _0002() {
  let scope = &te_scope(r#"{fromString: "2012-12-25"}"#);
  te_date(false, scope, r#"date(fromString)"#, 2012, 12, 25);
  te_number(false, scope, r#"date(fromString).day"#, 25, 0);
  te_number(false, scope, r#"date(fromString).month"#, 12, 0);
  te_number(false, scope, r#"date(fromString).year"#, 2012, 0);
}
