use super::test::Bencher;
use crate::builders::build_evaluator;
use dmntk_feel::values::Value;
use dmntk_feel::{scope, value_number, FeelNumber, Scope};

#[bench]
fn bench_0001(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"abs(-1)"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  let evaluator = build_evaluator(&node).unwrap();
  assert_eq!(value_number!(1), evaluator(&scope));
  b.iter(|| evaluator(&scope));
}

#[bench]
fn bench_0001_old(b: &mut Bencher) {
  let scope = scope!();
  let input = r#"abs(-1)"#;
  let node = dmntk_feel_parser::parse_textual_expression(&scope, input, false).unwrap();
  assert_eq!(value_number!(1), crate::evaluate(&scope, &node).unwrap());
  b.iter(|| crate::evaluate(&scope, &node).unwrap());
}
