/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Examples
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! Test files containing decision model definitions.
//! File names begin with the compliance level, followed by the number of the test.
//! Test examples borrowed from [DMN™ Technology Compatibility Kit](https://dmn-tck.github.io/tck/) project.
//! The content of each file is modified and differs from the original.

// compliance level 2
pub const DMN_2_0001: &str = include_str!("2_0001.dmn");
pub const DMN_2_0002: &str = include_str!("2_0002.dmn");
pub const DMN_2_0003: &str = include_str!("2_0003.dmn");
pub const DMN_2_0004: &str = include_str!("2_0004.dmn");
pub const DMN_2_0005: &str = include_str!("2_0005.dmn");
pub const DMN_2_0006: &str = include_str!("2_0006.dmn");
pub const DMN_2_0008: &str = include_str!("2_0008.dmn");
pub const DMN_2_0009: &str = include_str!("2_0009.dmn");
pub const DMN_2_0010: &str = include_str!("2_0010.dmn");
pub const DMN_2_0106: &str = include_str!("2_0106.dmn");

// compliance level 3
pub const DMN_3_0001: &str = include_str!("3_0001.dmn");
pub const DMN_3_0002: &str = include_str!("3_0002.dmn");
pub const DMN_3_0003: &str = include_str!("3_0003.dmn");
pub const DMN_3_0004: &str = include_str!("3_0004.dmn");
pub const DMN_3_0006: &str = include_str!("3_0006.dmn");
pub const DMN_3_0007: &str = include_str!("3_0007.dmn");
pub const DMN_3_0008: &str = include_str!("3_0008.dmn");
pub const DMN_3_0014: &str = include_str!("3_0014.dmn");
pub const DMN_3_0016: &str = include_str!("3_0016.dmn");
pub const DMN_3_0020: &str = include_str!("3_0020.dmn");
pub const DMN_3_0030: &str = include_str!("3_0030.dmn");
pub const DMN_3_0082: &str = include_str!("3_0082.dmn");
pub const DMN_3_0085: &str = include_str!("3_0085.dmn");
pub const DMN_3_0086: &str = include_str!("3_0086.dmn");
pub const DMN_3_0087: &str = include_str!("3_0087.dmn");
pub const DMN_3_0088: &str = include_str!("3_0088.dmn");
