/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

mod compatibility;

//
// /// Utility function that creates context from specified input.
// fn te_context(input: &str) -> FeelContext {
//   let scope = Scope::default();
//   match dmntk_feel_parser::parse_context(&scope, input, false) {
//     Ok(node) => match crate::evaluate(&scope, &node) {
//       Ok(value) => match value {
//         Value::Context(ctx) => return ctx,
//         _ => println!("ERROR (INVALID VALUE TYPE): {:?}", value),
//       },
//       Err(reason) => println!("{}", reason),
//     },
//     Err(reason) => println!("ERROR (REASON): {}", reason),
//   }
//   panic!("`te_context` failed");
// }

fn r(prefix: &str) -> impl Fn(&str) -> String + '_ {
  move |postfix: &str| {
    let mut line = prefix.to_owned();
    line.push(' ');
    line.push_str(postfix);
    line
  }
}

#[test]
fn a() {
  assert_eq!("alfa beta", r("alfa")("beta"))
}
