/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::model::errors::*;
use crate::model::ItemDefinitions;
use dmntk_common::Result;
use dmntk_feel::context::FeelContext;
use dmntk_model::model::{Definitions, FeelTypedElement, NamedElement};

pub fn evaluate_context_from_required_input(
  definitions: &Definitions,
  item_definitions: &ItemDefinitions,
  input_data_id: &str,
  ctx: &FeelContext,
  evaluated_context: &mut FeelContext,
) -> Result<()> {
  println!("AAA:INPUT_DATA_ID = {}", input_data_id);
  let input_data = definitions
    .input_data_by_id(input_data_id)
    .ok_or_else(|| input_data_with_id_not_found(input_data_id))?;
  println!("AAA:INPUT_DATA_FOUND");
  let variable = input_data.variable();
  let type_ref = variable.type_ref().as_ref().ok_or_else(|| input_data_without_type_reference(input_data_id))?;
  println!("AAA:INPUT_DATA_TYPE_REF_OK: {}", type_ref);
  let feel_type = variable.feel_type().as_ref().ok_or_else(empty_item_data_feel_type)?;
  println!("AAA:INPUT_DATA_FEEL_TYPE_OK");
  if feel_type.is_simple_built_in_type() {
    println!("AAA:INPUT_DATA_SIMPLE_TYPE");
    // SIMPLE TYPE, VALUE MUST BE TAKEN FROM CONTEXT
    let name = dmntk_feel_parser::parse_longest_name(variable.name())?;
    if let Some(external_value) = ctx.get_entry(&name) {
      let value = feel_type.retrieve_value_with_type_checking(external_value)?;
      evaluated_context.set_entry(&name, value);
    }
  } else {
    println!("AAA:INPUT_DATA_REFERENCED_TYPE");
    // REFERENCED TYPE, VALUE MUST BE TAKEN THROUGH ITEM DEFINITION
    let name = dmntk_feel_parser::parse_longest_name(variable.name())?;
    if let Some(external_value) = ctx.get_entry(&name) {
      let value = item_definitions.retrieve_value_by_name(&type_ref, external_value)?;
      evaluated_context.set_entry(&name, value);
    }
  }
  Ok(())
}
