/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::model::errors::*;
use crate::model::eval_input::evaluate_context_from_required_input;
use crate::model::ItemDefinitions;
use dmntk_common::{null_with_trace, Result, Stringify};
use dmntk_feel::context::FeelContext;
use dmntk_feel::values::{Value, VALUE_NULL};
use dmntk_model::model::*;

/// Evaluates a [Decision] by specified name.
///
/// # Arguments
///
/// - definitions    - definitions where the decision is searched,
/// - decision_name  - name of the decision to be evaluated,
/// - ctx            - external evaluation context.
///
pub fn evaluate_decision_by_name(definitions: &Definitions, name: &str, ctx: &FeelContext) -> Result<Value> {
  if let Some(decision) = definitions.decision_by_name(name) {
    eval_decision(definitions, decision, ctx)
  } else {
    Err(decision_with_name_not_found(name))
  }
}

/// Evaluates a [Decision].
fn eval_decision(definitions: &Definitions, decision: &Decision, ctx: &FeelContext) -> Result<Value> {
  println!("\nAAA:DECISION = {}", decision.name());
  if let Some(expression_instance) = decision.decision_logic() {
    println!("AAA:DECISION_LOGIC = {:?}", expression_instance);
    let item_definitions = ItemDefinitions::new(definitions);
    evaluate_context(ctx, decision, definitions, &item_definitions)?;
    // // values evaluated in requirements may be overwritten by input parameters
    // evl.zip(ext);
    // let scope: Scope = evl.into();
    // println!("DECISION_SCOPE={}", scope.stringify());
    // let result = eval_expression_instance(&scope, expression_instance)?;
    // println!("DECISION_RESULT={}", result.stringify());
    // println!("DECISION_RESULT_TYPE={:?}", result.type_of());
    // let output_type = decision.variable().feel_type();
    // println!("DECISION_OUTPUT_TYPE={:?}", output_type);
    // return if result.type_of().is_conformant(output_type) {
    //   Ok(result)
    // } else {
    //   // coercion of singleton list into single value
    //   if let Value::List(items) = &result {
    //     if items.len() == 1 {
    //       if items[0].type_of().is_conformant(output_type) {
    //         return Ok(items[0].clone());
    //       }
    //     }
    //   }
    //   // coercion of single value into singleton list
    //   if let FeelType::List(expected_inner_type) = output_type {
    //     if result.type_of().is_conformant(expected_inner_type.borrow()) {
    //       return Ok(Value::List(Values::new(vec![result])));
    //     }
    //   }
    //   println!("COERCION");
    //   Ok(null_with_trace!("coercion"))
    // };
    Ok(VALUE_NULL)
  } else {
    Ok(null_with_trace!("no decision logic"))
  }
}

/// Evaluates local context for specified [Decision].
fn evaluate_context(ctx: &FeelContext, decision: &Decision, definitions: &Definitions, item_definitions: &ItemDefinitions) -> Result<FeelContext> {
  println!("AAA:EXTERNAL_CONTEXT = {}", ctx.stringify());
  let mut evaluated_context: FeelContext = Default::default();
  //eval_knowledge_requirements(definitions, ctx, decision.knowledge_requirements(), &mut evaluated_ctx)?;

  for information_requirement in decision.information_requirements() {
    // if let Some(href) = information_requirement.required_decision() {
    //   if let Some(id) = href.strip_hash() {
    //     eval_required_decision_by_id(definitions, id, ctx, &mut evaluated_ctx)?;
    //   }
    // }
    if let Some(href) = information_requirement.required_input() {
      evaluate_context_from_required_input(definitions, item_definitions, href.into(), ctx, &mut evaluated_context)?;
    }
  }
  println!("AAA:EVALUATED_CONTEXT = {}", evaluated_context.stringify());
  Ok(evaluated_context)
}
