/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use super::*;

#[test]
fn test_positive_unary_tests() {
  let scope = &te_scope("{}");
  valid_unary_tests(false, scope, "-");
  valid_unary_tests(false, scope, "1");
  valid_unary_tests(false, scope, "1,2");
  valid_unary_tests(false, scope, "1,2,3");
  valid_unary_tests(false, scope, "[]");
  valid_unary_tests(false, scope, "[1]");
  valid_unary_tests(false, scope, "[1,2]");
  valid_unary_tests(false, scope, "[1,2,3]");
  valid_unary_tests(false, scope, "[1..2]");
  valid_unary_tests(false, scope, "not(1,2,3)");
}
