/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use dmntk_recognizer::dmntk_model::dmntk_feel_parser::dmntk_feel::dmntk_common::Result;
use dmntk_recognizer::dmntk_model::dmntk_feel_parser::dmntk_feel::values::Value;
use dmntk_recognizer::dmntk_model::dmntk_feel_parser::dmntk_feel::Scope;

pub(crate) mod enricher;
mod errors;
pub(crate) mod eval;
pub(crate) mod eval_bkm;
pub(crate) mod eval_dec;
pub(crate) mod eval_dec_service;
pub(crate) mod eval_dec_table;

#[cfg(test)]
mod tests;

/// Evaluates the decision table.
pub fn evaluate_decision_table_from_text(scope: &Scope, input: &str) -> Result<Value> {
  crate::model::eval_dec_table::evaluate_decision_table(scope, dmntk_recognizer::build(&input)?)
}

/// Evaluates a decision table against specified context.
pub fn evaluate_decision_table_and_context(decision_table_input: &str, context_input: &str) -> Result<Value> {
  let scope: Scope = crate::evaluate_context(&Scope::default(), context_input)?.into();
  evaluate_decision_table_from_text(&scope, decision_table_input)
}

/// Evaluates all tests associated with decision table.
pub fn evaluate_decision_table_and_test(_input: &str, _sep: &str) -> Result<(bool, Value, Value)> {
  //FIXME implement this feature
  unimplemented!()
}
