/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::model::errors::*;
use crate::model::eval::ModelEvaluator;
use dmntk_feel_parser::dmntk_feel::context::FeelContext;
use dmntk_feel_parser::dmntk_feel::dmntk_common::Result;
use dmntk_feel_parser::dmntk_feel::values::Value;
use dmntk_model::model::*;

/// Evaluates a [Decision] defined by specified name.
///
/// # Arguments
///
/// - definitions    - definitions where the decision is searched,
/// - decision_name  - name of the decision to be evaluated,
/// - ctx            - external evaluation context.
///
pub fn evaluate_decision_by_name(definitions: &Definitions, name: &str, ctx: &FeelContext) -> Result<Value> {
  if let Some(decision) = definitions.decision_by_name(name) {
    println!("\nAAA:DECISION = {}", decision.name());
    let evaluator = ModelEvaluator::new(&definitions)?;
    evaluator.evaluate_decision(decision, ctx)
  } else {
    Err(decision_with_name_not_found(name))
  }
}
