/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

use crate::model::errors::*;
use dmntk_feel_parser::dmntk_feel::context::FeelContext;
use dmntk_feel_parser::dmntk_feel::dmntk_common::Result;
use dmntk_feel_parser::dmntk_feel::values::{Value, VALUE_NULL};
use dmntk_model::model::Definitions;

/// Evaluates a business knowledge model specified by name.
pub fn evaluate_business_knowledge_model_by_name(definitions: &Definitions, name: &str, _ctx: &FeelContext) -> Result<Value> {
  if let Some(_decision) = definitions.business_knowledge_model_by_name(name) {
    Ok(VALUE_NULL)
  } else {
    Err(business_knowledge_model_with_name_not_found(name))
  }
}
