/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * FEEL and DMN model evaluator.
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

extern crate dmntk_examples;
extern crate dmntk_feel_parser;
extern crate dmntk_model;
extern crate dmntk_recognizer;
#[macro_use]
extern crate lazy_static;
extern crate regex;

mod feel;
mod model;

pub use crate::feel::{evaluate, evaluate_context, evaluate_equals, evaluate_function, evaluate_max, evaluate_min, evaluate_node_type, evaluate_sum};
pub use crate::model::enricher::enrich_model;
pub use crate::model::eval_bkm::evaluate_business_knowledge_model_by_name;
pub use crate::model::eval_dec::evaluate_decision_by_name;
pub use crate::model::eval_dec_service::evaluate_decision_service_by_name;
pub use crate::model::{evaluate_decision_table_and_context, evaluate_decision_table_and_test};
