/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Common definitions
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

//! Common definitions for components of Decision Model and Notation Toolkit.

extern crate serde;
extern crate serde_derive;
extern crate serde_yaml;
extern crate uriparse;

mod config;
mod constants;
mod errors;
mod examples;
mod feelify;
mod href;
mod jsonify;
mod macros;
mod stringify;

pub use config::{get_configuration, Configuration, ServerConfiguration};
pub use constants::{DMNTK_COPYRIGHT, DMNTK_EXECUTABLE, DMNTK_NAME, DMNTK_VERSION};
pub use errors::{DmntkError, Result};
pub use examples::{EXAMPLE_0001_CTX, EXAMPLE_0001_DTB, EXAMPLE_0002_CTX, EXAMPLE_0002_DTB};
pub use feelify::Feelify;
pub use href::{HRef, OptHRef};
pub use jsonify::Jsonify;
pub use stringify::Stringify;
