/*
 * DMNTK - Decision Model and Notation Toolkit
 *
 * Common definitions
 *
 * Copyright 2018-2021 Dariusz Depta Engos Software <dariusz.depta@engos.software>
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

/// Optional reference to an element.
pub type OptHRef = Option<HRef>;

/// Reference to an element using `href` attribute.
#[derive(Debug, Clone)]
pub struct HRef(String);

impl ToString for HRef {
  /// Converts this reference to its string representation.
  fn to_string(&self) -> String {
    self.0.clone()
  }
}

impl From<String> for HRef {
  /// Converts a string to a reference.
  fn from(value: String) -> Self {
    Self(value)
  }
}

impl HRef {
  /// Strips the `#` prefix from this reference, if exists.
  pub fn strip_hash(&self) -> Option<&str> {
    self.0.strip_prefix('#')
  }
}
