use regex::Regex;
use static_init::dynamic;

use crate::models::Log;
use crate::transforms::Transform;

#[dynamic]
static EMAIL: Regex = Regex::new(r#"(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|"(?: [\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f] | \\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])"#).unwrap();

pub struct EmailTransform;

impl Transform for EmailTransform {
    fn apply(&self, log: &mut Log) {
        log.message = log
            .message
            .split(' ')
            .map(|val| match EMAIL.is_match(val) {
                true => "•".repeat(val.len()),
                false => String::from(val),
            })
            .collect::<Vec<String>>()
            .join(" ");
    }
}
