pub(in crate) trait RefCounted: Clone {
    fn retain(&self) -> Self {
        Clone::clone(self)
    }

    /// This method is added precisely to make `.clone()` calls ambiguous (in
    /// non-`Clone`-generic context). The idea being that in such contexts,
    /// explicit `.retain()` ought to be more readable than `.clone`-ing.
    ///
    /// We disable `rustfmt` to let the "suggestion" comment be on the same
    /// line, since that's the only visible line in the "ambiguous method"
    /// message.
    #[rustfmt::skip]
    fn clone(&self) -> Self { // Use `.retain()` instead.
        Clone::clone(self)
    }
}
impl<T: ?Sized> RefCounted for ::std::rc::Rc<T> {}
impl<T: ?Sized> RefCounted for ::std::sync::Arc<T> {}
