use_prelude!();
use super::*;

#[derive(Debug)]
pub struct SingleDocumentLiveQueryEvent {
    pub(crate) is_initial: bool,
    pub(crate) old_document: Option<ffi_sdk::BoxedDocument>,
}

impl SingleDocumentLiveQueryEvent {
    pub fn is_initial(&self) -> bool {
        self.is_initial
    }

    pub fn old_document(&self) -> &Option<ffi_sdk::BoxedDocument> {
        &self.old_document
    }
}

impl SingleDocumentLiveQueryEvent {
    pub fn hash(&self, doc: &Option<ffi_sdk::BoxedDocument>) -> Result<u64, DittoError> {
        let zero_or_one_doc: &[_] = doc.as_ref().map_or(&[], ::core::slice::from_ref);
        unsafe { ffi_sdk::ditto_documents_hash(zero_or_one_doc.into()).ok() }
    }

    pub fn hash_mnemonic(
        &self,
        doc: &Option<ffi_sdk::BoxedDocument>,
    ) -> Result<String, DittoError> {
        let zero_or_one_doc: &[_] = doc.as_ref().map_or(&[], ::core::slice::from_ref);
        let mnemonic_c_str =
            unsafe { ffi_sdk::ditto_documents_hash_mnemonic(zero_or_one_doc.into()).ok()? };
        Ok(mnemonic_c_str.unwrap().to_string())
    }
}
