mod common;

use common::DEFAULT_TEST_TIMEOUT;

use ::tokio::{sync::watch, time::timeout};

#[test]
fn ensure_activated_before_starting_sync() {
    let ditto = common::get_inactive_ditto().unwrap();
    dbg!(ditto.is_activated());
    let res = ditto.try_start_sync();
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "Sync could not be started because Ditto has not yet been activated. This can be achieved with a successful call to `set_license_token`. If you need to obtain a license token then please visit https://portal.ditto.live.");
}

#[test]
fn ensure_online_is_activated_before_starting_sync() {
    let ditto = common::get_online_ditto().unwrap();
    assert!(ditto.is_activated());
    //@ditto/snippet-start sync-basic
    let res = ditto.try_start_sync();
    //@ditto/snippet-end
    assert!(res.is_ok());
}

/// A basic smoke test which tests that the FFI bindings are wired up
/// correctly and nothing horrible happens.
#[test]
fn test_garbage_collection() {
    let ditto = common::get_ditto().unwrap();
    ditto.run_garbage_collection();
}

/// Test that setting a device name is working correctly
#[::tokio::test]
async fn test_set_device_name() {
    let ditto = common::get_ditto().unwrap();
    ditto.set_device_name("my_custom_device_name");

    let (done_tx, mut done_rx) = watch::channel(());
    let _presence_observer = ditto.observe_peers_v2(move |presence| {
        let local_peer = presence
            .peers
            .iter()
            .find(|p| p.id == presence.local_peer)
            .unwrap();

        assert_eq!(&local_peer.device_name, "my_custom_device_name");
        done_tx.send(()).unwrap();
    });

    timeout(DEFAULT_TEST_TIMEOUT, done_rx.changed())
        .await
        .expect("timed out")
        .unwrap();
}
