use crate::prelude::{identity, Ditto, DittoError, LogLevel};

pub fn setup_ditto() -> Result<Ditto, DittoError> {
    let ditto = Ditto::builder()
        .with_temp_dir()
        .with_identity(|ditto_root| identity::OfflinePlayground::random(ditto_root))?
        .with_minimum_log_level(LogLevel::Error)
        .build()?;
    ditto.set_license_from_env("DITTO_LICENSE")?;
    Ok(ditto)
}
