use_prelude!();

#[derive(Debug)]
pub struct CollectionsEvent {
    pub is_initial: bool,
    pub collections: Vec<Collection>,
    pub old_collections: Vec<Collection>,
    pub insertions: Box<[usize]>,
    pub deletions: Box<[usize]>,
    pub updates: Box<[usize]>,
    pub moves: Vec<LiveQueryMove>,
}

impl CollectionsEvent {
    pub fn initial(collections: Vec<Collection>) -> Self {
        CollectionsEvent {
            is_initial: true,
            collections,
            old_collections: vec![],
            insertions: vec![].into(),
            deletions: vec![].into(),
            updates: vec![].into(),
            moves: vec![],
        }
    }

    pub fn update(
        collections: Vec<Collection>,
        old_collections: Vec<Collection>,
        insertions: Box<[usize]>,
        deletions: Box<[usize]>,
        updates: Box<[usize]>,
        moves: Vec<LiveQueryMove>,
    ) -> Self {
        CollectionsEvent {
            is_initial: false,
            collections,
            old_collections,
            insertions,
            deletions,
            updates,
            moves,
        }
    }
}
