mod common;

#[test]
fn ensure_activated_before_starting_sync() {
    let ditto = common::get_inactive_ditto().unwrap();
    dbg!(ditto.is_activated());
    let res = ditto.try_start_sync();
    assert!(res.is_err());
    let err = res.err().unwrap();
    assert_eq!(err.to_string(), "Sync could not be started because Ditto has not yet been activated. This can be achieved with a successful call to `set_license_token`. If you need to obtain a license token then please visit https://portal.ditto.live.");
}

#[test]
fn ensure_online_is_activated_before_starting_sync() {
    let ditto = common::get_online_ditto().unwrap();
    assert!(ditto.is_activated());
    let res = ditto.try_start_sync();
    assert!(res.is_ok());
}

/// A basic smoke test which tests that the FFI bindings are wired up
/// correctly and nothing horrible happens.
#[test]
fn garbage_collection() {
    let dk = common::get_ditto().unwrap();
    dk.run_garbage_collection();
}
