macro_rules! use_prelude {
    () => {
        #[allow(unused_imports)]
        use crate::utils::prelude::*;
    };
}

/// Scoped `use`
macro_rules! using {
    (
        match $expr:tt {
            use :: $($path:tt)::+ ;
            $($match_body:tt)*
        }
    ) => (match $expr { expr => {
        use :: $($path)::+ ;
        match expr { $($match_body)* }
    }});

    (
        match $expr:tt {
            use $($path:tt)::+ ;
            $($match_body:tt)*
        }
    ) => (match $expr { expr => {
        use $($path)::+;
        match expr { $($match_body)* }
    }});

    (
        :: $($path:tt)::+ in $($rest:tt)*
    ) => (
        const _: () = {
            use :: $($path)::+ ;

            $($rest)*
        };
    );
    (
        $($path:tt)::+ in $($rest:tt)*
    ) => (
        const _: () = {
            use $($path)::+ ;

            $($rest)*
        };
    );
}

// macro_rules! FIXME {(
//     $($msg:expr),+ $(; $($body:tt)*)?
// ) => ({
//     #[deprecated(note = "FIXME")] struct __; let _ = __;
//     ::log::warn!("FIXME: {}", ::std::format_args!($($msg),*));
//     $($($body)*)?
// })}

#[allow(clippy::deprecated_cfg_attr)]
#[cfg_attr(rustfmt, rustfmt::skip)]
macro_rules! with_doc {(
    #[doc = $doc:expr]
    $item:item
) => (
    #[doc = $doc]
    $item
)}

macro_rules! trait_alias {(
    $( #[$attr:meta] )*
    $pub:vis
    trait $TraitName:ident = $($super:tt)*
) => (
    with_doc! {
        #[doc = concat!(
            "An alias for `", stringify!($($super)*), "`."
        )]
        $( #[$attr] )*
        $pub
        trait $TraitName
        where
            Self : $($super)*
        {}
    }

    impl<__ : ?Sized> $TraitName for __
    where
        Self : $($super)*
    {}
)}
